// Completely different Netview program, works with new file format
// DCE, going to go on website

//BEGIN rnd.c
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define WINMAIN \
	void SBCLIB_main2(char *); \
	int WINAPI WinMain(HINSTANCE hinst,HINSTANCE previous,LPSTR cmdline,int showcmd) \
		{hinstance=hinst; SBCLIB_main2(GetCommandLine()); return 0;} \
	void SBCLIB_main2(char *cmdline)

#ifndef SBCLIB_DEBUG // Anti-cone boffers
#define mallocex(a,b) malloc(a)
#define isalloc(a) 1
#define DEBUG_screendump(a)
#define DEBUG_exon()
#define DEBUG_exoff()
#define DEBUG_prevpage()
#define DEBUG_nextpage()
#endif

double Max(const double a,const double b) {return (a>b)?a:b;}
double Min(const double a,const double b) {return (a<b)?a:b;}
int Maxi(const int a,const int b) {return (a>b)?a:b;}
int Mini(const int a,const int b) {return (a<b)?a:b;}
double frnd(const double lim) {return (double)rand()/RAND_MAX*lim;}
int rnd(const int lim) {return (int)frnd((double)lim-0.0001);}
int c2i(const char x) {return (x<0)?(int)x+256:x;}

int fgetstr(char **ps,FILE *in,char *term) // Warning: check that *ps is NULL if unallocated before use
{
	char tc[256]; int l,ch; long p=ftell(in);
	for (memset(tc,0,256),tc[0]=1;ch=*term;term++) tc[ch]=1;
	for (l=0;ch=fgetc(in), !tc[ch] && ch!=EOF;l++);
	if (*ps) free(*ps); *ps=(char *)malloc(l+1);
	fseek(in,p,SEEK_SET);
	if (l) fread(*ps,1,l,in); (*ps)[l]=0;
	fgetc(in); // Go past the terminating char as well
	if (ch==EOF) return 0; else if (!ch) return 256; else return ch;
}
//END rnd.c
//BEGIN lset.c
typedef struct
{
	void *a,**hook; // The array and access hook
	int m; // Number of members
	int buffer,minbuffer,elementsize;
	float minpercentusage;
} LSet;

#define LSet(type) LSet_new(sizeof(type))

int LSet_initalloc=1;

LSet LSet_new(const int s)
{
	LSet ret;
	ret.m=0;
	ret.buffer=ret.minbuffer=LSet_initalloc;
	ret.elementsize=s;
	ret.a=mallocex(ret.buffer*ret.elementsize,"LSet buffer");
	ret.minpercentusage=60;
	ret.hook=NULL;
	return ret;
}

int LSet_add(LSet *s,const void *x)
{
	int m=s->m,sz=s->elementsize;
	if (m>=s->buffer)
	{
		void *na;
		s->buffer=(float)(m+1)/(0.5+0.005*s->minpercentusage);
		na=mallocex(s->buffer*sz,"LSet buffer");
		memcpy(na,s->a,m*sz); free(s->a); s->a=na;
		if (s->hook) *(s->hook)=na;
	}
	memcpy((unsigned char *)s->a+m*sz,x,sz); s->m++;
	return m;
}

int LSet_indexof(LSet *s,void *x)
{
	int n;
	for (n=s->m-1;n>=0;n--) if (!memcmp((unsigned char *)s->a+n*s->elementsize,x,s->elementsize)) return n;
	return -1;
}

void LSet_remove(LSet *s,const int n)
{
	int m=s->m-1,sz=s->elementsize;
	if (n>m || n<0) return;
	if (n<m) memcpy((unsigned char *)s->a+n*sz,(unsigned char *)s->a+m*sz,sz); s->m--;
	if ((float)m/s->buffer<0.01*s->minpercentusage && s->buffer>s->minbuffer)
	{
		void *na;
		s->buffer=Maxi(s->minbuffer,(float)m/(0.5+0.005*s->minpercentusage));
		na=mallocex(s->buffer*sz,"LSet buffer");
		memcpy(na,s->a,m*sz); free(s->a); s->a=na;
		if (s->hook) *(s->hook)=na;
	}
}

void LSet_hookup(LSet *s,void **h)
{
	s->hook=h;
	*(s->hook)=s->a;
}

void LSet_clear(LSet *s)
{
	free(s->a);
	s->m=0; s->buffer=s->minbuffer;
	s->a=mallocex(s->buffer*s->elementsize,"LSet buffer (just cleared)");
	if (s->hook) *(s->hook)=s->a;
}

void LSet_free(LSet s)
{
	if (s.hook) *(s.hook)=NULL;
	free(s.a);
}
//END lset.c
//BEGIN graphics.c
int xmin=0,ymin=0,xres,yres,cpp; char bgbank;
#define IF_CLIPCHECK(X,Y) if (X>=xmin) if (X<xres) if (Y>=ymin) if (Y<yres)
unsigned char *shad=NULL;
int mx=0,my=0,mb_real,mb_stuck=1,mb=0,shadpitch;
char keyhit=0,gotch[100]="",minimise_window=0;
unsigned char keystate[256],oldkeystate[256];
#define GRAPHICS24(X,Y,S) GFX_genericsetup(hinstance,X,Y,S,3,0);
#define KEY(x) (keystate[x]>>7)
#define LOOP for (char leave=(dealwithmessages(),0);!leave;leave|=dealwithmessages()|KEY(VK_Q)|KEY(VK_ESCAPE))
//BEGIN gfx_dx.c
#include <windows.h>
#include <ddraw.h>
HWND winhandle=NULL; HINSTANCE hinstance=NULL;
#define CLEARDXSTRUCT(x) memset(&x,0,sizeof(x)); x.dwSize=sizeof(x);
LPDIRECTDRAW lpdd=0;
DDSURFACEDESC ddsdprim,ddsdshad;
LPDIRECTDRAWSURFACE ddprim=0,ddshad=0;

void gracefulexit()
{
	if (ddprim) IDirectDrawSurface_Release(ddprim);
	if (ddshad) IDirectDrawSurface_Release(ddshad);
	if (lpdd) IDirectDraw_Release(lpdd);
}

void update();

LRESULT CALLBACK windowproc(HWND hwnd,UINT msg,WPARAM wp,LPARAM lp)
{
	PAINTSTRUCT ps;
	keyhit=0;
	switch (msg)
	{
		case WM_PAINT:
			BeginPaint(hwnd,&ps);
			#ifdef SBCLIB_GRAPHICS_WINDOWED
			if (ddprim && ddshad) update();
			#endif
			EndPaint(hwnd,&ps);
			return 0;
		case WM_DESTROY:
			PostQuitMessage(0); exit(0);
			return 0;
		case WM_CHAR:
			keyhit=1;
			if (strlen(gotch)<99)
			{
				gotch[strlen(gotch)+1]=0;
				gotch[strlen(gotch)]=(char)wp;
			}
			break;
		case WM_MOUSEMOVE:
		case WM_LBUTTONUP: case WM_LBUTTONDOWN: case WM_LBUTTONDBLCLK:
		case WM_RBUTTONUP: case WM_RBUTTONDOWN: case WM_RBUTTONDBLCLK:
			mx=(int)LOWORD(lp);
			my=(int)HIWORD(lp);
			mb_real=(int)wp&3;
			if (!mb_real) mb_stuck=0;
			if (!mb_stuck) mb=mb_real;
			break;
		default:;
	}
	return DefWindowProc(hwnd,msg,wp,lp);
}

void werror(char *message) {exit(1);}
void dderr(const int l,const HRESULT r) {if (r!=DD_OK) exit(2);}

HWND makethewindow(HINSTANCE hinst,int xs,int ys,const char *task_name)
{
	HWND ret;
	WNDCLASS winclass;

	xres=xs; yres=ys;

	winclass.style=CS_DBLCLKS|CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
	winclass.lpfnWndProc=windowproc;
	winclass.cbClsExtra=0;
	winclass.cbWndExtra=0;
	winclass.hInstance=hinstance=hinst;
	winclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	winclass.hCursor=LoadCursor(NULL,IDC_ARROW);
	winclass.hbrBackground=GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName=NULL;
	winclass.lpszClassName="mallards";

	if (!RegisterClass(&winclass)) werror("Couldn't register window class");
	#ifdef SBCLIB_GRAPHICS_WINDOWED
	ret=CreateWindow("mallards",task_name,WS_VISIBLE,
		0,0,xres+2*GetSystemMetrics(SM_CXFRAME),yres+GetSystemMetrics(SM_CYCAPTION)+2*GetSystemMetrics(SM_CYFRAME),
		NULL,NULL,hinstance,NULL);
	#else
	ret=CreateWindow("mallards",task_name,WS_POPUP|WS_VISIBLE,0,0,xres,yres,NULL,NULL,hinstance,NULL);
	ShowCursor(0);
	#endif
	if (!ret) werror("Couldn't create a window");
	return winhandle=ret; // Return value for backward compatibility only
}

void directxsetup24()
{
	dderr(2401,DirectDrawCreate(NULL,&lpdd,NULL));
	dderr(2402,IDirectDraw_SetCooperativeLevel(lpdd,winhandle,DDSCL_ALLOWMODEX|DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE|DDSCL_ALLOWREBOOT));
	if (IDirectDraw_SetDisplayMode(lpdd,xres,yres,24)==DD_OK) cpp=3;
	else {dderr(2403,IDirectDraw_SetDisplayMode(lpdd,xres,yres,32)); cpp=4;}
	CLEARDXSTRUCT(ddsdprim);
	ddsdprim.dwFlags=DDSD_CAPS;
	ddsdprim.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
	dderr(2405,IDirectDraw_CreateSurface(lpdd,&ddsdprim,&ddprim,NULL));
}

void makebank()
{
	CLEARDXSTRUCT(ddsdshad);
	ddsdshad.dwFlags=DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT;
	ddsdshad.dwWidth=xres; ddsdshad.dwHeight=yres;
	ddsdshad.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	dderr(7,IDirectDraw_CreateSurface(lpdd,&ddsdshad,&ddshad,NULL));
	dderr(9,IDirectDrawSurface_Lock(ddshad,NULL,&ddsdshad,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL));
	shad=(unsigned char *)ddsdshad.lpSurface; shadpitch=ddsdshad.lPitch;
}

void gdriversetup()
{
	directxsetup24();
	makebank();
}

int dealwithmessages()
{
	MSG msg;
	PALETTEENTRY spal[256]; unsigned char *rshad;
	char recover=0,rec_shad=0;
	memcpy(oldkeystate,keystate,256);
	GetKeyboardState(keystate);
	if (minimise_window ||
		KEY(VK_LWIN) || KEY(VK_RWIN) ||
		(KEY(VK_LCONTROL) || KEY(VK_RCONTROL)) && KEY(VK_ESCAPE)) {CloseWindow(winhandle); minimise_window=0;}
	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE) || IsIconic(winhandle)) // Get messages and/or sleep while minimised
	{
		if (IsIconic(winhandle) && !recover)
		{
			if (ddshad)
			{
				rshad=(unsigned char *)mallocex(yres*shadpitch,"Recovery rshad array, dealwithmessages()");
				memcpy(rshad,shad,yres*shadpitch);
				IDirectDraw_Release(ddshad); ddshad=0;
				rec_shad=1;
			}
			if (lpdd) IDirectDraw_Release(lpdd);
			recover=1;
		}
		if (msg.message==WM_QUIT) gracefulexit();
		TranslateMessage(&msg); DispatchMessage(&msg);
		if (IsIconic(winhandle)) Sleep(30);
	}
	if (recover)
	{
		if (rec_shad) {makebank(); memcpy(shad,rshad,yres*shadpitch); free(rshad);}
	}
	return 0;
}
//END gfx_dx.c
void putpix3(const unsigned x,const unsigned y,const unsigned c)
{
	IF_CLIPCHECK(x,y)
	{
		unsigned char *p=shad+x*3+y*shadpitch,*pc=&c;
		p[0]=pc[0]; p[1]=pc[1]; p[2]=pc[2];
	}
}

void putpix4(const unsigned x,const unsigned y,const unsigned c)
{
	IF_CLIPCHECK(x,y)
	{
		unsigned char *p=shad+x*4+y*shadpitch,*pc=&c;
		p[0]=pc[0]; p[1]=pc[1]; p[2]=pc[2];
	}
}

unsigned getpix3(const unsigned x,const unsigned y)
{
	IF_CLIPCHECK(x,y)
	{
		unsigned char *i=shad+x*3+y*shadpitch;
		return *i|(*(i+1)<<8)|(*(i+2)<<16);
	}
	return 0;
}

unsigned getpix4(const unsigned x,const unsigned y)
{
	IF_CLIPCHECK(x,y)
	{
		unsigned char *i=shad+x*4+y*shadpitch;
		return *i|(*(i+1)<<8)|(*(i+2)<<16);
	}
	return 0;
}

void rect3(int x,const int y,int xs,const int ys,const unsigned c)
{
	int py,px,miny=Maxi(y,ymin),maxy=Mini(y+ys,yres);
	unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
	if (miny>=yres || maxy<ymin) return;
	if (x<xmin) {xs+=x-xmin; x=xmin;}
	p=shad+miny*shadpitch+x*3;
	if (x+xs<xmin || x>=xres || xs<=0) return;
	xs=Mini(xs,xres-x);
	for (py=miny;py<maxy;py++)
	{
		for (px=xs-1;px>=0;px--) {*(p++)=cb; *(p++)=cg; *(p++)=cr;}
		p+=shadpitch-xs*3;
	}
}

void rect4(int x,const int y,int xs,const int ys,const unsigned c)
{
	int py,px,miny=Maxi(y,ymin),maxy=Mini(y+ys,yres);
	unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
	if (miny>=yres || maxy<ymin) return;
	if (x<xmin) {xs+=x-xmin; x=xmin;}
	p=shad+miny*shadpitch+(x<<2);
	if (x+xs<xmin || x>=xres || xs<=0) return;
	xs=Mini(xs,xres-x);
	for (py=miny;py<maxy;py++)
	{
		for (px=xs-1;px>=0;px--) {*(p++)=cb; *(p++)=cg; *(p++)=cr; p++;}
		p+=shadpitch-(xs<<2);
	}
}

void box3(const int x,const int y,const int xs,const int ys,const unsigned c)
{
	int px,py; unsigned char cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF,*p;
	if (xs<0 || ys<0 || x>=xres || y>=yres || x+xs<xmin || y+ys<ymin) return;
	if (x>=xmin && x<xres) for (py=Maxi(ymin,y);py<=Mini(yres-1,y+ys);py++) {p=shad+x*3+py*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (x+xs>=xmin && x+xs<xres) for (py=Maxi(ymin,y);py<=Mini(yres-1,y+ys);py++)  {p=shad+(x+xs)*3+py*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (y>=ymin && y<yres) for (px=Maxi(xmin,x);px<=Mini(xres-1,x+xs);px++) {p=shad+px*3+y*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (y+ys>=ymin && y+ys<yres) for (px=Maxi(xmin,x);px<=Mini(xres-1,x+xs);px++) {p=shad+px*3+(y+ys)*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
}

void box4(const int x,const int y,const int xs,const int ys,const unsigned c)
{
	int px,py; unsigned char cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF,*p;
	if (xs<0 || ys<0 || x>=xres || y>=yres || x+xs<xmin || y+ys<ymin) return;
	if (x>=xmin && x<xres) for (py=Maxi(ymin,y);py<=Mini(yres-1,y+ys);py++) {p=shad+(x<<2)+py*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (x+xs>=xmin && x+xs<xres) for (py=Maxi(ymin,y);py<=Mini(yres-1,y+ys);py++)  {p=shad+((x+xs)<<2)+py*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (y>=ymin && y<yres) for (px=Maxi(xmin,x);px<=Mini(xres-1,x+xs);px++) {p=shad+(px<<2)+y*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
	if (y+ys>=ymin && y+ys<yres) for (px=Maxi(xmin,x);px<=Mini(xres-1,x+xs);px++) {p=shad+(px<<2)+(y+ys)*shadpitch; p[0]=cb; p[1]=cg; p[2]=cr;}
}

void (*putpix)(const unsigned,const unsigned,const unsigned),
	(*rect)(int,const int,int,const int,const unsigned),
	(*box)(const int,const int,const int,const int,const unsigned),
	putpix3(const unsigned,const unsigned,const unsigned),
	putpix4(const unsigned,const unsigned,const unsigned),
	rect3(int,const int,int,const int,const unsigned),
	rect4(int,const int,int,const int,const unsigned),
	box3(const int,const int,const int,const int,const unsigned),
	box4(const int,const int,const int,const int,const unsigned);

unsigned (*getpix)(const unsigned,const unsigned);

void cl(const unsigned char);

void GFX_setfuncptrs()
{
	if (cpp==3) {putpix=putpix3; getpix=getpix3; rect=rect3; box=box3;}
	else if (cpp==4) {putpix=putpix4; getpix=getpix4; rect=rect4; box=box4;}
}

void GFX_genericsetup(const void *hinst,const int xs,const int ys,const char *name,
	const int ncpp,const char nbgbank)
{
	xres=xs; yres=ys; cpp=ncpp; bgbank=nbgbank;
	makethewindow(hinst,xres,yres,name); // System dependant
	gdriversetup(); // System dependent
	GFX_setfuncptrs();
	cl(0);
}

void update()
{
	RECT rect;
	rect.left=0; rect.right=xres; rect.top=0; rect.bottom=yres;
	IDirectDrawSurface_Unlock(ddshad,NULL);
	IDirectDrawSurface_BltFast(ddprim,0,0,ddshad,&rect,DDBLTFAST_NOCOLORKEY|DDBLTFAST_WAIT);
	IDirectDrawSurface_Lock(ddshad,NULL,&ddsdshad,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
	shad=(unsigned char *)ddsdshad.lpSurface; shadpitch=ddsdshad.lPitch;
}

void ccl(const unsigned char c)
{
	update();
	memset(shad,c,shadpitch*yres);
}

void cl(const unsigned char c)
{
	memset(shad,c,shadpitch*yres);
	ccl(c);
}

void line(float x1,float y1,float x2,float y2,const unsigned c)
{
	float dx=x2-x1,dy=y2-y1,k,xr=xres-1,yr=yres-1;
	if (x1<xmin)
	{
		if (x2<xmin) return;
		y1-=(x1-xmin)*dy/dx; x1=xmin;
	}
	else if (x2<xmin)
	{
		y2-=(x2-xmin)*dy/dx; x2=xmin;
	}
	if (x1>xr)
	{
		if (x2>xr) return;
		y1-=(x1-xr)*dy/dx; x1=xr;
	}
	else if (x2>xr)
	{
		y2-=(x2-xr)*dy/dx; x2=xr;
	}
	if (y1<ymin)
	{
		if (y2<ymin) return;
		x1-=(y1-ymin)*dx/dy; y1=ymin;
	}
	else if (y2<ymin)
	{
		x2-=(y2-ymin)*dx/dy; y2=ymin;
	}
	if (y1>yr)
	{
		if (y2>yr) return;
		x1-=(y1-yr)*dx/dy; y1=yr;
	}
	else if (y2>yr)
	{
		x2-=(y2-yr)*dx/dy; y2=yr;
	}
	dx=x2-x1; dy=y2-y1;
	if (dx*dx+dy*dy<(float)0.1)
	{
		unsigned char *p=shad+(int)(x1)*cpp+(int)(y1)*shadpitch;
		if (cpp==1) *p=c;
		else {p[0]=c&0xFF; p[1]=(c>>8)&0xFF; p[2]=c>>16;}
		return;
	}
	if (dx+dy<(float)0)
	{
		dx=-dx; dy=-dy;
		k=x1; x1=x2; x2=k;
		k=y1; y1=y2; y2=k;
	}
	if (dx>dy)
	{
		k=dy/dx;
		unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
		for (x1=floor(x1)*cpp,x2*=cpp;x1<=x2;x1+=cpp)
		{
			p=shad+(int)x1+(int)y1*shadpitch;
			p[0]=cb; p[1]=cg; p[2]=cr;
			y1+=k;
		}
	}
	else
	{
		k=dx/dy;
		unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
		for (;y1<=y2;y1++)
		{
			p=shad+(int)x1*cpp+(int)y1*shadpitch;
			p[0]=cb; p[1]=cg; p[2]=cr;
			x1+=k;
		}
	}
}

void circle(const float x,const float y,const float r,const unsigned c)
{
	int n,s=Maxi(1,Mini(floor(r/sqrt(2)+1.5),floor(r+0.5)));
	for (n=0;n<s;n++)
	{
		float k=sqrt(r*r-n*n);
		putpix(x+n,y+k,c);
		putpix(x+n,y-k,c);
		putpix(x-n,y+k,c);
		putpix(x-n,y-k,c);
		putpix(x+k,y+n,c);
		putpix(x+k,y-n,c);
		putpix(x-k,y+n,c);
		putpix(x-k,y-n,c);
	}
}

unsigned and24(const unsigned x,const unsigned y)
{
	unsigned xr=x>>16,xg=(x>>8)&0xFF,xb=x&0xFF,
		yr=y>>16,yg=(y>>8)&0xFF,yb=y&0xFF;
	return (((xr*yr)>>8)<<16)|(((xg*yg)>>8)<<8)|((xb*yb)>>8);
}

unsigned or24(const unsigned x,const unsigned y)
{
	return 0xFFFFFF^and24(0xFFFFFF^x,0xFFFFFF^y);
}
//END graphics.c
//BEGIN bitmapfonts.c
struct BF_font_tag;

typedef struct
{
	struct BF_font_tag *from;
	float xscale,yscale,skew,boldness;
	int render_c,render_i;
} BF_variation;

BF_variation BF_variation_none={NULL, 1,1,0,0, 0,0},BF_curvar;

typedef struct BF_font_tag
{
	unsigned char *letter[512];
	unsigned char width,height,monospacing; // Calculated by BF_fontlookups(BF_font *)
	char *name;
	BF_variation v;
} BF_font;

LSet BF_fontset; BF_font **BF_array=NULL;
BF_font *BF_curfont=NULL;
unsigned char **BF_letter,BF_width,BF_height,BF_monospacing;

char BF_mono=0; int BF_leftclipmargin=0;
enum BF_painttype {Solid=1,And=2,Or=3,Alpha=4} BF_paint=Or;

void BF_make_cra() {}

void BF_deletefont(BF_font *f)
{
	int n;
	for (n=0;n<512;n++) free(f->letter[n]);
	free(f->name); free(f);
	LSet_remove(&BF_fontset,LSet_indexof(&BF_fontset,&f));
	if (BF_curfont==f) BF_curfont=BF_array[rnd(BF_fontset.m)];
}

void BF_fontlookups(BF_font *f)
{
	int n;
	f->width=0; for (n=0;n<512;n++) f->width=Max(f->width,f->letter[n][0]);
	f->height=0; for (n=0;n<512;n++) f->height=Max(f->height,f->letter[n][1]);
	f->monospacing=f->letter['C'][0]+1;
}

BF_font *BF_makeblank(const char *handle)
{
	int n,i; BF_font *f;
	BF_make_cra();
	for (n=0;n<BF_fontset.m;n++) if (!strcmpi(BF_array[n]->name,handle)) BF_deletefont(BF_array[n]);
	f=(BF_font *)mallocex(sizeof(BF_font),"BF_font structure");
	f->name=(char *)mallocex(strlen(handle)+1,"Handle to BF_font");
	LSet_add(&BF_fontset,&f);
	strcpy(f->name,handle);
	for (i=0;i<512;i++)
	{
		f->letter[i]=(unsigned char *)mallocex(5,"Letter in blank font (24bit)");
		f->letter[i][0]=f->letter[i][1]=1; f->letter[i][2]=f->letter[i][3]=0; f->letter[i][4]=128;
	}
	BF_fontlookups(f);
	return f;
}

void orbitc(const int x,const int y,const unsigned char *bitmap,const unsigned col)
{
	int x1=x,y1=y;
	unsigned xs=bitmap[0],ys=bitmap[1],px=(x1<xmin)?x1+=xres-xmin:0,py=(y1<ymin)?y1+=yres-ymin:0;
	unsigned char *c=bitmap+2,*p=shad+y1*shadpitch+x1*cpp,*l=shad+(yres-1)*shadpitch+(xres-xs)*cpp;
	int colr=col>>16,colg=(col>>8)&0xFF,colb=col&0xFF;
	for (py=0;py<ys;py++)
	{
		if (p>=l) p-=shadpitch*(yres-1);
		for (px=0;px<xs;px++)
		{
			if (c[0]!=0x56) {p[0]=0xFF^(((0xFF^((colb*c[0])>>8))*(0xFF^p[0]))>>8); p[1]=0xFF^(((0xFF^((colg*c[1])>>8))*(0xFF^p[1]))>>8); p[2]=0xFF^(((0xFF^((colr*c[2])>>8))*(0xFF^p[2]))>>8);}
			else if (c[1]!=0x34) {p[0]=0xFF^(((0xFF^((colb*c[0])>>8))*(0xFF^p[0]))>>8); p[1]=0xFF^(((0xFF^((colg*c[1])>>8))*(0xFF^p[1]))>>8); p[2]=0xFF^(((0xFF^((colr*c[2])>>8))*(0xFF^p[2]))>>8);}
			else if (c[2]!=0x12) {p[0]=0xFF^(((0xFF^((colb*c[0])>>8))*(0xFF^p[0]))>>8); p[1]=0xFF^(((0xFF^((colg*c[1])>>8))*(0xFF^p[1]))>>8); p[2]=0xFF^(((0xFF^((colr*c[2])>>8))*(0xFF^p[2]))>>8);}
			p+=cpp; c+=3;
		}
		p+=shadpitch-xs*cpp;
	}
}

void andpixnec3(const unsigned x,const unsigned y,const unsigned c)
{
	unsigned char *b=shad+x*3+y*shadpitch;
	int c0=c&0xFF,c1=(c>>8)&0xFF,c2=c>>16;
	b[0]=((int)b[0]*c0)>>8;
	b[1]=((int)b[1]*c1)>>8;
	b[2]=((int)b[2]*c2)>>8;
}

void andpixnec4(const unsigned x,const unsigned y,const unsigned c)
{
	unsigned char *b=shad+(x<<2)+y*shadpitch;
	int c0=c&0xFF,c1=(c>>8)&0xFF,c2=c>>16;
	b[0]=((int)b[0]*c0)>>8;
	b[1]=((int)b[1]*c1)>>8;
	b[2]=((int)b[2]*c2)>>8;
}

void orpixnec3(const unsigned x,const unsigned y,const unsigned c)
{
	unsigned char *b=shad+x*3+y*shadpitch;
	int c0=0xFF^(c&0xFF),c1=0xFF^((c>>8)&0xFF),c2=0xFF^(c>>16);
	b[0]=0xFF^(((0xFF^b[0])*c0)>>8);
	b[1]=0xFF^(((0xFF^b[1])*c1)>>8);
	b[2]=0xFF^(((0xFF^b[2])*c2)>>8);
}

void orpixnec4(const unsigned x,const unsigned y,const unsigned c)
{
	unsigned char *b=shad+(x<<2)+y*shadpitch;
	int c0=0xFF^(c&0xFF),c1=0xFF^((c>>8)&0xFF),c2=0xFF^(c>>16);
	b[0]=0xFF^(((0xFF^b[0])*c0)>>8);
	b[1]=0xFF^(((0xFF^b[1])*c1)>>8);
	b[2]=0xFF^(((0xFF^b[2])*c2)>>8);
}

void (*andpixnec)(const unsigned,const unsigned,const unsigned)=NULL,
	(*orpixnec)(const unsigned,const unsigned,const unsigned)=NULL,
	andpixnec3(const unsigned,const unsigned,const unsigned),
	andpixnec4(const unsigned,const unsigned,const unsigned),
	orpixnec3(const unsigned,const unsigned,const unsigned),
	orpixnec4(const unsigned,const unsigned,const unsigned);

void andpix(const unsigned x,const unsigned y,const unsigned c)
{
	if (x>=xmin && x<xres) if (y>=ymin && y<yres) andpixnec(x,y,c);
}

void orpix(const unsigned x,const unsigned y,const unsigned c)
{
	if (c) if (x>=xmin && x<xres) if (y>=ymin && y<yres) orpixnec(x,y,c);
}

void (*paintbitc)(int,int,unsigned char *,unsigned),
	(*paintpix)(const unsigned,const unsigned,const unsigned);

void bfsetpaint(enum BF_painttype x)
{
	if (x==Or) {paintbitc=orbitc; paintpix=orpix;}
	BF_paint=x;
}

void BF_setfuncptrs()
{
	if (cpp==3) {andpixnec=andpixnec3; orpixnec=orpixnec3;}
	else if (cpp==4) {andpixnec=andpixnec4; orpixnec=orpixnec4;}
	bfsetpaint(BF_paint);
}

void bfsetfontpointer(const BF_font *f)
{
	if (BF_curfont==f) return;
	BF_curfont=f; BF_curvar=f->v;
	BF_letter=f->letter; BF_width=f->width; BF_height=f->height;
	BF_monospacing=f->monospacing;
}

void loadfont(const char *filename,const char *handle)
{
	int n,i,x,y; BF_font *f;
	FILE *in=fopen(filename,"rb");
	if (in)
	{
		f=(BF_font *)mallocex(sizeof(BF_font),desc);
		f->name=(char *)mallocex(strlen(handle)+1,"BF_font handle");
		strcpy(f->name,handle);
		for (n=0;n<512;n++)
		{
			x=fgetc(in); y=fgetc(in);
			if (!feof(in))
			{
				int px,py; unsigned char *d;
				f->letter[n]=(unsigned char *)mallocex(2+x*y*3,desc);
				f->letter[n][0]=x; f->letter[n][1]=y;
				d=f->letter[n]+2;
				for (py=0;py<y;py++) for (px=0;px<x;px++)
				{
					unsigned char c=fgetc(in);
					if (c>16 && c<40)
					{
						c=(c-16)*11;
						*(d++)=c; *(d++)=c; *(d++)=c;
					}
					else {*(d++)=0x56; *(d++)=0x34; *(d++)=0x12;}
				}
			}
			else
			{
				f->letter[n]=(unsigned char *)mallocex(5,"Letter off EOF");
				f->letter[n][0]=f->letter[n][1]=1; f->letter[n][2]=f->letter[n][3]=0; f->letter[n][4]=128;
			}
		}
		fclose(in);
	}
	else f=BF_makeblank(handle);
	BF_fontlookups(f);
	f->v=BF_variation_none; f->v.from=f; f->v.render_c=512;
	BF_make_cra();
	if (!andpixnec) BF_setfuncptrs();
	if (!BF_array) {BF_fontset=LSet(BF_font *); LSet_hookup(&BF_fontset,&BF_array);}
	LSet_add(&BF_fontset,&f);
	bfsetfontpointer(f);
}

int bflength(char *s)
{
	int ret;
	if (BF_mono) return BF_monospacing*strlen(s)-1;
	else for (ret=0;*s && *s!='\n';s++) ret+=BF_letter[c2i(*s)][0]+1;
	return ret-1;
}

void bfwrite(const int ox,int y,const char *s,const unsigned c)
{ // Accepts 2-byte widechars with escapes: 02 AB CD
	int n,i,x=ox,nx,ny=y+BF_height-1,clipmargin=xmin+BF_leftclipmargin;
	for (n=0;s[n] && x<xres;n++)
	{
		int sn=c2i(s[n]);
		if (sn==2) {sn=c2i(s[n+1])*256+c2i(s[n+2]); n+=2;}
		if (sn=='\n') {x=ox; y+=BF_height+1;}
		else
		{
			nx=x+BF_letter[sn][0]-1;
			if (x>=clipmargin && y>=ymin && nx<xres && ny<yres) paintbitc(x,y,BF_letter[sn],c);
			else
			{
				int px,py,xs=BF_letter[sn][0],ys=BF_letter[sn][1];
				unsigned char *p=BF_letter[sn]+2;
				int r1=c>>16,g1=(c>>8)&0xFF,b1=c&0xFF,r2,g2,b2;
				for (py=0;py<ys;py++) for (px=0;px<xs;px++)
				{
					b2=*(p++); g2=*(p++); r2=*(p++);
					if (x+px>=clipmargin && x+px<xres && y+py>=ymin && y+py<yres
						&& (b2!=0x56 || g2!=0x34 || r2!=0x12))
						paintpix(x+px,y+py,(((r1*r2)>>8)<<16)|(((g1*g2)>>8)<<8)|((b1*b2)>>8));
				}
			}
			x=nx+2;
		}
	}
}
//END bitmapfonts.c
//BEGIN netdb.c
typedef struct {unsigned ip; char *name;} Node;
typedef struct {int a,b;} Link; // a,b are indexes in the nodes LSet

typedef struct
{
	LSet nodes,links;
	Node *na; Link *la;
} Database;

Database *newdb()
{
	Database *d=(Database *)malloc(sizeof(Database));
	d->nodes=LSet(Node); d->links=LSet(Link);
	LSet_hookup(&d->nodes,&d->na);
	LSet_hookup(&d->links,&d->la);
	return d;
}

Database *loadfile(const char *filename,unsigned long *psize)
{
	Database *d=newdb();
	FILE *in=fopen(filename,"rb");
	if (in)
	{
		int mn,ml; char str[1000];
		fread(&mn,sizeof(int),1,in);
		fread(&ml,sizeof(int),1,in);
		for (int n=0;n<mn;n++)
		{
			Node c;
			fread(&c.ip,sizeof(unsigned),1,in);
			c.name=NULL; fgetstr(&c.name,in,"");
			LSet_add(&d->nodes,&c);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Loading %s: %d nodes",filename,n);
	report(str);
}
#endif
		}
		for (int n=0;n<ml;n++)
		{
			Link e;
			fread(&e.a,sizeof(int),1,in);
			fread(&e.b,sizeof(int),1,in);
			LSet_add(&d->links,&e);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Loading %s: %d links",filename,n);
	report(str);
}
#endif
		}
		if (psize) *psize=ftell(in);
		fclose(in);
	}
	else if (psize) *psize=0;
	return d;
}

void cleardb(Database *d)
{
	for (int n=d->nodes.m-1;n>=0;n--) free(d->na[n].name);
	LSet_clear(&d->nodes);
	LSet_clear(&d->links);
}

void freedbptr(Database *d)
{
	cleardb(d);
	LSet_free(d->nodes); LSet_free(d->links);
	free(d);
}
//END netdb.c

void iptoxy(unsigned ip,float *x,float *y,char center)
{
	*x=0; *y=0; float s=1.0/16;

	*x+=s*(ip&0x0F);
	s/=16;
	*y+=s*(ip&0xF0);
	ip>>=8;

	*x+=s*(ip&0x0F);
	s/=16;
	*y+=s*(ip&0xF0);
	ip>>=8;

	*x+=s*(ip&0x0F);
	s/=16;
	*y+=s*(ip&0xF0);
	ip>>=8;

	*x+=s*(ip&0x0F);
	s/=16;
	*y+=s*(ip&0xF0);
	if (center) {*x+=s*8; *y+=s*8;}
}

struct {char links;} prefs={0};

WINMAIN
{
	int n,i; char str[1000];
	GRAPHICS24(800,600,"Lost in IP4-space (Stephen Brooks 2002)");
	loadfont("font.dat","normal");
	Database *db=loadfile("web.dat",NULL);
	float cx=0.5,cy=0.5,cxs=0,cys=0,zoom=yres*0.9,zs=1;
	int sel=-1; unsigned ip=-1;
	unsigned char *ll=(unsigned char *)malloc(db->links.m),
		*nl=(unsigned char *)malloc(db->nodes.m);
	memset(nl,0xFF,db->nodes.m); memset(ll,0xFF,db->links.m);
	LOOP
	{
		Node *na=db->na; Link *la=db->la;
		SetCursorPos(xres/2,yres/2);
		if (prefs.links)
		{
			for (int j=0;j<=4;j++) for (n=db->links.m-1;n>=0;n--)
			{
				Link e=la[n];
				if (nl[e.a]==j || nl[e.b]==j)
				{
					ll[n]=Min(nl[e.a],nl[e.b]);
					nl[e.a]=Min(nl[e.a],nl[e.b]+1);
					nl[e.b]=Min(nl[e.b],nl[e.a]+1);
				}
			}
			for (n=db->links.m-1;n>=0;n--) if (ll[n]<0xFF) // Plot links
			{
				Link e=la[n];
				float x1,y1,x2,y2;
				iptoxy(na[e.a].ip,&x1,&y1,1);
				x1=(x1-cx)*zoom+xres/2; y1=(y1-cy)*zoom+yres/2;
				iptoxy(na[e.b].ip,&x2,&y2,1);
				x2=(x2-cx)*zoom+xres/2; y2=(y2-cy)*zoom+yres/2;
				line(x1,y1,x2,y2,0x000102*(255/(2+ll[n])));
			}
		}
		if (cx>=0 && cx<1 && cy>=0 && cy<1) for (i=1,n=0;i<=65536 && i<zoom/10;i<<=4,n++)
		{
			int x=floor(cx*i),y=floor(cy*i);
			float px=((float)x/i-cx)*zoom+xres/2,py=((float)y/i-cy)*zoom+yres/2,
				pz=(1.0/i)*zoom;
			unsigned col=0x008060+n*(0x20-0x2000);
			box(px,py,pz,pz,col);
			if ((((int)floor(cx*i*16))&0xF) || (((int)floor(cy*i*16))&0xF))
			{
				strcpy(str,"[");
				if (n==0) strcpy(str,"[*]");
				else for (int j=n-1;j>=0;j--) sprintf(str,"%s%d.",str,((x>>(j<<2))&0xF)|(((y>>(j<<2))&0xF)<<4));
				str[strlen(str)-1]=']';
				bfwrite(px+2,py-1-BF_height,str,or24(col,0x808080));
				if (6+bflength(str)+BF_height<pz)
				{
					line(px,py,px,py-3-BF_height,col);
					line(px,py-3-BF_height,px+3+bflength(str),py-3-BF_height,col);
					line(px+3+bflength(str),py-3-BF_height,px+6+bflength(str)+BF_height,py,col);
				}
			}
		}
		float bdd=1e20; sel=-1;
		for (n=db->nodes.m-1;n>=0;n--) // Plot nodes
		{
			float x,y;
			iptoxy(na[n].ip,&x,&y,1);
			float dd=(x-cx)*(x-cx)+(y-cy)*(y-cy);
			if (dd<bdd) {bdd=dd; sel=n; ip=na[n].ip;}
			x=(x-cx)*zoom+xres/2;
			y=(y-cy)*zoom+yres/2;
			float uz=zoom/65536;
			if (uz<0.5) putpix(x,y,0x800000|(getpix(x,y)>>1));
			else if (x>=-100 && y>=-100 && x<xres+100 && y<yres+100)
				circle(x,y,uz/3,0x800000);
		}
		memset(nl,0xFF,db->nodes.m); memset(ll,0xFF,db->links.m);
		if (sel>=0)
		{
			ip=na[sel].ip;
			float x,y;
			iptoxy(ip,&x,&y,0);
			x=(x-cx)*zoom+xres/2;
			y=(y-cy)*zoom+yres/2;
			bfwrite(x+2,y+4,na[sel].name,0x00C080);
			nl[sel]=0;
		}
		bfwrite(0,yres-BF_height,"Use mouse and buttons to navigate, L to toggle links display",0x607080);
		ccl(0);
		if (mb&1) zs+=0.03;
		if (mb&2) zs-=0.03;
		zoom*=zs; zs=zs*0.7+0.3;
		cxs+=0.3*(float)(mx-xres/2)/zoom;
		cys+=0.3*(float)(my-yres/2)/zoom;
		cx+=cxs; cy+=cys; cxs*=0.7; cys*=0.7;
		if (KEY(VK_L)) prefs.links^=1;
	}
	freedbptr(db);
}

