#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <windows.h>
#include <ddraw.h>
// BEGIN #include <rnd.c>
#ifndef SBCLIB_DEBUG // Anti-cone boffers
#define mallocex(a,b) malloc(a)
#define isalloc(a) 1
#define DEBUG_screendump(a)
#define DEBUG_exon()
#define DEBUG_exoff()
#define DEBUG_prevpage()
#define DEBUG_nextpage()
#endif
#define WINMAIN int WINAPI WinMain(HINSTANCE hinst,HINSTANCE previous,LPSTR cmdline,int showcmd)
double Max(const double a,const double b) {return (a>b)?a:b;}
double sq(const double x) {return x*x;}
int Maxi(const int a,const int b) {return (a>b)?a:b;}
int Mini(const int a,const int b) {return (a<b)?a:b;}
int c2i(const char x) {return (x<0)?(int)x+256:x;}
int nonegi(const int x) {return (x<0)?0:x;}
double frnd(const double lim) {return (double)rand()/RAND_MAX*lim;}
int rnd(const int lim) {return (int)frnd((double)lim-0.0001);}
double Min(const double a,const double b) {return (a<b)?a:b;}
// END #include <rnd.c>
// BEGIN #include <graphics.c>
#define CLEARDXSTRUCT(x) memset(&x,0,sizeof(x)); x.dwSize=sizeof(x);

#define KEY(x) (keystate[x]>>7)
#define KEYUP(x) while (KEY(x) && !dealwithmessages())
#define KHIT(x) ((keystate[x]&~oldkeystate[x])>>7)

#define GRAPHICS(x,y,s) makethewindow(hinst,x,y,s); directxsetup(); makebank(); cl(0);
#define GRAPHICSB(x,y,s) makethewindow(hinst,x,y,s); directxsetup(); makebanks(); cl(0);
#define GRAPHICS24(x,y,s) makethewindow(hinst,x,y,s); directxsetup24(); makebank(); cl(0);
#define GRAPHICS24B(x,y,s) makethewindow(hinst,x,y,s); directxsetup24(); makebanks(); cl(0);

LPDIRECTDRAW lpdd;
DDSURFACEDESC ddsdprim,ddsdshad;
LPDIRECTDRAWSURFACE ddprim=0,ddshad=0;
LPDIRECTDRAWPALETTE ddpal;

int xres,yres,cpp;
HWND winhandle=NULL; HINSTANCE hinstance=NULL;
unsigned char *shad,*back,*prim;
int mx=0,my=0,mb=0,primpitch,shadpitch;
char keyhit=0,gotch[100]="",timeup=0,minimise_window=0;
unsigned char keystate[256],oldkeystate[256];
PALETTEENTRY pal[256];

void gracefulexit()
{
	if (ddprim) IDirectDraw_Release(ddprim);
	if (ddshad) IDirectDraw_Release(ddshad);
	if (lpdd) IDirectDraw_Release(lpdd);
}

void werror(char *message)
{
	char str[100];
	gracefulexit();
	MessageBox(NULL,message,"Oh sod it",MB_OK);
	PostQuitMessage(0); exit(0);
}

void dderr(const int loc,const HRESULT ddresult)
{
	if (ddresult!=DD_OK)
	{
		char str[100];
		sprintf(str,"DirectDraw error %08X @ %d",ddresult,loc);
		werror(str);
	}
}

void update();

LRESULT CALLBACK windowproc(HWND hwnd,UINT msg,WPARAM wp,LPARAM lp)
{
	int n;
	PAINTSTRUCT ps;
	keyhit=0;
	switch (msg)
	{
		case WM_PAINT:
			BeginPaint(hwnd,&ps);
			#ifdef SBCLIB_GRAPHICS_WINDOWED
			if (ddprim && ddshad) update();
			#endif
			EndPaint(hwnd,&ps);
			return 0;
		case WM_DESTROY:
			PostQuitMessage(0); exit(0);
			return 0;
		case WM_CHAR:
			keyhit=1;
			if (strlen(gotch)<99)
			{
				gotch[strlen(gotch)+1]=0;
				gotch[strlen(gotch)]=(char)wp;
			}
			break;
		case WM_MOUSEMOVE:
		case WM_LBUTTONUP: case WM_LBUTTONDOWN: case WM_LBUTTONDBLCLK:
		case WM_RBUTTONUP: case WM_RBUTTONDOWN: case WM_RBUTTONDBLCLK:
			mx=(int)LOWORD(lp);
			my=(int)HIWORD(lp);
			mb=(int)wp&3;
			break;
		default:;
	}
	return DefWindowProc(hwnd,msg,wp,lp);
}

HWND makethewindow(HINSTANCE hinst,int xs,int ys,const char *task_name)
{
	HWND ret;
	WNDCLASS winclass;

	xres=xs; yres=ys;

	winclass.style=CS_DBLCLKS|CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
	winclass.lpfnWndProc=windowproc;
	winclass.cbClsExtra=0;
	winclass.cbWndExtra=0;
	winclass.hInstance=hinstance=hinst;
	winclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	winclass.hCursor=LoadCursor(NULL,IDC_ARROW);
	winclass.hbrBackground=GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName=NULL;
	winclass.lpszClassName="mallards";

	if (!RegisterClass(&winclass)) werror("Couldn't register window class");
	#ifdef SBCLIB_GRAPHICS_WINDOWED
	ret=CreateWindow("mallards",task_name,WS_VISIBLE,
		0,0,xres+2*GetSystemMetrics(SM_CXFRAME),yres+GetSystemMetrics(SM_CYCAPTION)+2*GetSystemMetrics(SM_CYFRAME),
		NULL,NULL,hinstance,NULL);
	#else
	ret=CreateWindow("mallards",task_name,WS_POPUP|WS_VISIBLE,0,0,xres,yres,NULL,NULL,hinstance,NULL);
	ShowCursor(0);
	#endif
	if (!ret) werror("Couldn't create a window");
	return winhandle=ret; // Return value for backward compatibility only
}

void directxsetup()
{
	int n;
	for (n=0;n<256;n++) pal[n].peFlags=PC_NOCOLLAPSE;
	for (n=0;n<16;n++)
	{
		pal[n].peRed=!!(n&4)*(128+127*!!(n&8));
		pal[n].peGreen=!!(n&2)*(128+127*!!(n&8));
		pal[n].peBlue=!!(n&1)*(128+127*!!(n&8));
	}
	for (n=16;n<40;n++)
		pal[n].peRed=pal[n].peGreen=pal[n].peBlue=(n-16)*11;
	for (n=40;n<256;n++)
	{
		pal[n].peRed=(n-40)%6*51;
		pal[n].peGreen=(n-40)/6%6*51;
		pal[n].peBlue=(n-40)/36%6*51;
	}
	dderr(1,DirectDrawCreate(NULL,&lpdd,NULL));
	#ifdef SBCLIB_GRAPHICS_WINDOWED
	dderr(1302,IDirectDraw_SetCooperativeLevel(lpdd,NULL,DDSCL_NORMAL));
	#else
	dderr(2,IDirectDraw_SetCooperativeLevel(lpdd,winhandle,DDSCL_ALLOWMODEX|DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE|DDSCL_ALLOWREBOOT));
	dderr(3,IDirectDraw_SetDisplayMode(lpdd,xres,yres,8));
	dderr(4,IDirectDraw_CreatePalette(lpdd,DDPCAPS_8BIT|DDPCAPS_INITIALIZE|DDPCAPS_ALLOW256,pal,&ddpal,NULL));
	#endif
	cpp=1;
	CLEARDXSTRUCT(ddsdprim);
	#ifdef SBCLIB_GRAPHICS_FLIPPING
	ddsdprim.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
	ddsdprim.dwBackBufferCount=1;
	ddsdprim.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;
	// The DDSCAPS_COMPLEX flag indicates that coordinates are of the form x+iy
	#else
	ddsdprim.dwFlags=DDSD_CAPS;
	ddsdprim.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;
	#endif
	dderr(5,IDirectDraw_CreateSurface(lpdd,&ddsdprim,&ddprim,NULL));
	#ifndef SBCLIB_GRAPHICS_WINDOWED
	dderr(6,IDirectDrawSurface_SetPalette(ddprim,ddpal));
	#endif
}

void makebank()
{
	#ifdef SBCLIB_GRAPHICS_FLIPPING
	ddsdshad=ddsdprim;
	ddsdshad.ddsCaps.dwCaps=DDSCAPS_BACKBUFFER;
	IDirectDrawSurface_GetAttachedSurface(ddprim,&ddsdshad.ddsCaps,&ddshad);
	dderr(9,IDirectDrawSurface_Lock(ddshad,NULL,&ddsdshad,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL));
	shad=(unsigned char *)ddsdshad.lpSurface; shadpitch=ddsdshad.lPitch;
	#elif defined(SBCLIB_GRAPHICS_WINDOWED)
	shad=(unsigned char *)malloc(xres*yres*cpp); shadpitch=xres*cpp;
	#else
	CLEARDXSTRUCT(ddsdshad);
	ddsdshad.dwFlags=DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT;
	ddsdshad.dwWidth=xres; ddsdshad.dwHeight=yres;
	ddsdshad.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN|DDSCAPS_SYSTEMMEMORY;
	dderr(7,IDirectDraw_CreateSurface(lpdd,&ddsdshad,&ddshad,NULL));
	if (cpp==1) dderr(8,IDirectDrawSurface_SetPalette(ddshad,ddpal));
	dderr(9,IDirectDrawSurface_Lock(ddshad,NULL,&ddsdshad,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL));
	shad=(unsigned char *)ddsdshad.lpSurface; shadpitch=ddsdshad.lPitch;
	#endif
}

int dealwithmessages()
{
	MSG msg;
	PALETTEENTRY spal[256]; unsigned char *rshad,*rback;
	char recover=0,rec_shad=0;
	memcpy(oldkeystate,keystate,256);
	GetKeyboardState(keystate);
	if (minimise_window) {CloseWindow(winhandle); minimise_window=0;}
	while (PeekMessage(&msg,NULL,0,0,PM_REMOVE) || IsIconic(winhandle)) // Get messages and/or sleep while minimised
	{
		if (IsIconic(winhandle) && !recover)
		{
			if (cpp==1) dderr(16,IDirectDrawPalette_GetEntries(ddpal,0,0,256,spal));
			if (ddshad)
			{
				rshad=(unsigned char *)malloc(yres*shadpitch);
				memcpy(rshad,shad,yres*shadpitch);
				IDirectDraw_Release(ddshad); ddshad=0;
				rec_shad=1;
			}
			if (lpdd) IDirectDraw_Release(lpdd);
			recover=1;
		}
		if (msg.message==WM_QUIT) gracefulexit();
		TranslateMessage(&msg); DispatchMessage(&msg);
		if (IsIconic(winhandle)) Sleep(30);
	}
	if (recover)
	{
		directxsetup();
		if (rec_shad) {makebank(); memcpy(shad,rshad,yres*shadpitch); free(rshad);}
		if (cpp==1) dderr(17,IDirectDrawPalette_SetEntries(ddpal,0,0,256,spal));
	}
	return 0;
}

void writepal666(const float gamma)
{
	int n; float r[256],g[256],b[256];
	for (n=0;n<16;n++)
	{
		r[n]=((n&4)>0)?0.5+0.5*((n&8)>0):0;
		g[n]=((n&2)>0)?0.5+0.5*((n&8)>0):0;
		b[n]=((n&1)>0)?0.5+0.5*((n&8)>0):0;
	}
	r[8]=g[8]=b[8]=0.25;
	for (n=16;n<40;n++)
		r[n]=g[n]=b[n]=(float)(n-16)/23;
	for (n=40;n<256;n++)
	{
		r[n]=0.2*((n-40)%6);
		g[n]=0.2*((n-40)/6%6);
		b[n]=0.2*((n-40)/36);
	}
	for (n=0;n<256;n++)
	{
		pal[n].peRed=pow(r[n],1.0/gamma)*255.4;
		pal[n].peGreen=pow(g[n],1.0/gamma)*255.4;
		pal[n].peBlue=pow(b[n],1.0/gamma)*255.4;
		pal[n].peFlags=PC_NOCOLLAPSE;
	}
	#ifdef SBCLIB_GRAPHICS_WINDOWED
	if (GFX_pfa) {free(GFX_pfa); GFX_pfa=NULL;}
	#else
	dderr(21,IDirectDrawPalette_SetEntries(ddpal,0,0,256,pal));
	#endif
}

void update()
{
	RECT rect;
	rect.left=0; rect.right=xres; rect.top=0; rect.bottom=yres;
	IDirectDrawSurface_Unlock(ddshad,NULL);
	IDirectDrawSurface_BltFast(ddprim,0,0,ddshad,&rect,DDBLTFAST_NOCOLORKEY|DDBLTFAST_WAIT);
	IDirectDrawSurface_Lock(ddshad,NULL,&ddsdshad,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
	shad=(unsigned char *)ddsdshad.lpSurface; shadpitch=ddsdshad.lPitch;
}

void ccl(const unsigned char c)
{
	update();
	memset(shad,c,shadpitch*yres);
}

void cl(const unsigned char c)
{
	memset(shad,c,shadpitch*yres);
	ccl(c);
}

void putpix(const unsigned x,const unsigned y,const unsigned c)
{
	if (x<xres) if (y<yres) shad[x+y*shadpitch]=c;
}

void rect(int x,const int y,int xs,const int ys,const unsigned c)
{
	int py,ymin=Maxi(y,0),ymax=Mini(y+ys,yres);
	unsigned char *p;
	if (ymin>=yres || ymax<0) return;
	if (x<0) {xs+=x; x=0;}
	p=shad+ymin*shadpitch+x;
	if (x+xs<0 || x>=xres || xs<=0) return;
	xs=Mini(xs,xres-x);
	for (py=ymin;py<ymax;py++)
	{
		memset(p,c,xs);
		p+=shadpitch;
	}
}

void line(float x1,float y1,float x2,float y2,const unsigned c)
{
	float dx=x2-x1,dy=y2-y1,k,xr=xres-1,yr=yres-1;
	if (x1<0)
	{
		if (x2<0) return;
		y1-=x1*dy/dx; x1=0;
	}
	else if (x2<0)
	{
		y2-=x2*dy/dx; x2=0;
	}
	if (x1>xr)
	{
		if (x2>xr) return;
		y1-=(x1-xr)*dy/dx; x1=xr;
	}
	else if (x2>xr)
	{
		y2-=(x2-xr)*dy/dx; x2=xr;
	}
	if (y1<0)
	{
		if (y2<0) return;
		x1-=y1*dx/dy; y1=0;
	}
	else if (y2<0)
	{
		x2-=y2*dx/dy; y2=0;
	}
	if (y1>yr)
	{
		if (y2>yr) return;
		x1-=(y1-yr)*dx/dy; y1=yr;
	}
	else if (y2>yr)
	{
		x2-=(y2-yr)*dx/dy; y2=yr;
	}
	dx=x2-x1; dy=y2-y1;
	if (dx*dx+dy*dy<0.1)
	{
		unsigned char *p=shad+(int)x1*cpp+(int)y1*shadpitch;
		if (cpp==1) *p=c;
		else {p[0]=c&0xFF; p[1]=(c>>8)&0xFF; p[2]=c>>16;}
		return;
	}
	if (dx+dy<0)
	{
		dx=-dx; dy=-dy;
		k=x1; x1=x2; x2=k;
		k=y1; y1=y2; y2=k;
	}
	if (dx>dy)
	{
		k=dy/dx;
		if (cpp==1) for (;x1<=x2;x1++)
		{
			shad[(int)x1+(int)y1*shadpitch]=c;
			y1+=k;
		}
		else
		{
			unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
			for (x1=floor(x1)*cpp,x2*=cpp;x1<=x2;x1+=cpp)
			{
				p=shad+(int)x1+(int)y1*shadpitch;
				p[0]=cb; p[1]=cg; p[2]=cr;
				y1+=k;
			}
		}
	}
	else
	{
		k=dx/dy;
		if (cpp==1) for (;y1<=y2;y1++)
		{
			shad[(int)x1+(int)y1*shadpitch]=c;
			x1+=k;
		}
		else
		{
			unsigned char *p,cr=c>>16,cg=(c>>8)&0xFF,cb=c&0xFF;
			for (;y1<=y2;y1++)
			{
				p=shad+(int)x1*cpp+(int)y1*shadpitch;
				p[0]=cb; p[1]=cg; p[2]=cr;
				x1+=k;
			}
		}
	}
}

void box(const int x,const int y,const int xs,const int ys,const unsigned c)
{
	int px,py;
	if (xs<0 || ys<0 || x>=xres || y>=yres || x+xs<0 || y+ys<0) return;
	if (x>=0 && x<xres) for (py=Maxi(0,y);py<=Mini(yres-1,y+ys);py++) shad[x+py*shadpitch]=c;
	if (x+xs>=0 && x+xs<xres) for (py=Maxi(0,y);py<=Mini(yres-1,y+ys);py++) shad[x+xs+py*shadpitch]=c;
	if (y>=0 && y<yres) memset(shad+Maxi(0,x)+y*shadpitch,c,Mini(xres-1,x+xs)-Maxi(0,x)+1);
	if (y+ys>=0 && y+ys<yres) memset(shad+Maxi(0,x)+(y+ys)*shadpitch,c,Mini(xres-1,x+xs)-Maxi(0,x)+1);
}

void circle(const float x,const float y,const float r,const unsigned char c)
{
	int n; float s=Min(r/sqrt(2)+1,r);
	for (n=0;n<s;n++)
	{
		float k=sqrt(r*r-n*n);
		putpix(x+n,y+k,c);
		putpix(x+n,y-k,c);
		putpix(x-n,y+k,c);
		putpix(x-n,y-k,c);
		putpix(x+k,y+n,c);
		putpix(x+k,y-n,c);
		putpix(x-k,y+n,c);
		putpix(x-k,y-n,c);
	}
}

void fpalcoeffs(float *r,float *g,float *b)
{
	int n;
	for (n=0;n<256;n++)
	{
		r[n]=(float)pal[n].peRed/256;
		g[n]=(float)pal[n].peGreen/256;
		b[n]=(float)pal[n].peBlue/256;
	}
}
// END #include <graphics.c>
// BEGIN #include <bitmapfonts.c>
#define BF_maxfonts 100
unsigned char BF_and[255][255],BF_or[255][255],BF_inv[255],BF_cra_loaded=0;

typedef struct
{
	unsigned char *letter[512],width,height,monospacing;
} BF_font;

int BF_numfonts=0;
BF_font *BF_array[BF_maxfonts]; char *BF_handle[BF_maxfonts];
BF_font *BF_curfont;
unsigned char **BF_letter,BF_width,BF_height,BF_monospacing;

char BF_mono=0; int BF_leftclipmargin=0;
enum BF_painttype {Solid,And,Or,Alpha} BF_paint=Or;

void orbitcr(int x,int y,const unsigned char *bitmap,const unsigned char *cr)
{
	unsigned xs=bitmap[0],ys=bitmap[1],px=(x<0)?(x+=xres):0,py=(y<0)?(y+=yres):0;
	unsigned char *c=bitmap+2,d,*p=shad+y*shadpitch+x,*l=shad+yres*shadpitch-xs;
	for (py=0;py<ys;py++)
	{
		for (px=0,d=*c;px<xs;px++,c++,p++,d=*c) if (d && d!=255) *p=BF_or[*p][cr[d]];
		p+=shadpitch-xs;
		if (p>=l) p-=shadpitch*(yres-1);
	}
}

void orbitc(const int x,const int y,const unsigned char *bitmap,const unsigned col)
{
	orbitcr(x,y,bitmap,BF_and[col]);
}

void orpix(const unsigned x,const unsigned y,const unsigned c)
{
	unsigned char *b;
	if (c) if (x<xres) if (y<yres) {b=shad+x+y*shadpitch; *b=BF_or[*b][c];}
}

void (*paintbitc)(int,int,unsigned char *,unsigned)=orbitc,
	(*paintpix)(const unsigned,const unsigned,const unsigned)=orpix;

void BF_make_cra()
{
	int n,i; FILE *in;
	if (BF_cra_loaded) return;
	if (in=fopen(".\\crarray.cgf","rb"))
	{
		unsigned char cra[256][255];
		for (n=0;n<256;n++) fread(cra[n],1,255,in);
		for (n=0;n<255;n++) for (i=0;i<255;i++)
		{
			BF_and[n][i]=cra[Mini(n,i)][Maxi(n,i)];
			BF_or[n][i]=cra[Maxi(n,i)+1][Mini(n,i)];
		}
		fclose(in);
	}
	else if (cpp==1)
	{
		float r[256],g[256],b[256];
		unsigned char cra[256][255];
		fpalcoeffs(r,g,b);
		for (n=0;n<255;n++)
		{
			for (i=0;i<=n;i++)
			{
				float rr=r[n]*r[i],gg=g[n]*g[i],bb=b[n]*b[i],bd=1e6,dd;
				unsigned char c,cc;
				for (c=0;c<40;c++) if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) {bd=dd; cc=c;}
				c=40+(int)floor(rr*5+0.5)+(int)floor(gg*5+0.5)*6+(int)floor(bb*5+0.5)*36;
			    if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) {bd=dd; cc=c;}
				cra[i][n]=BF_and[n][i]=BF_and[i][n]=cc;
				rr=1.0-(1.0-r[n])*(1.0-r[i]); gg=1.0-(1.0-g[n])*(1.0-g[i]); bb=1.0-(1.0-b[n])*(1.0-b[i]); bd=1e6;
				for (c=0;c<40;c++) if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) {bd=dd; cc=c;}
				c=40+(int)floor(rr*5+0.5)+(int)floor(gg*5+0.5)*6+(int)floor(bb*5+0.5)*36;
				if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) cc=c;
				cra[n+1][i]=BF_or[n][i]=BF_or[i][n]=cc;
			}
			if (shad)
			{
				line(0,yres/2,xres-1,yres/2,42);
				line(0,yres/2,xres*sq(n)/sq(255),yres/2,45);
				ccl(0);
			}
		}
		in=fopen(".\\crarray.cgf","wb");
		for (n=0;n<256;n++) fwrite(cra[n],1,255,in);
		fclose(in);
	}
	if (cpp==1) // Colour inverses
	{
		float r[256],g[256],b[256];
		fpalcoeffs(r,g,b);
		for (n=0;n<255;n++)
		{
			float rr=1.0-r[n],gg=1.0-g[n],bb=1.0-b[n],bd=1e6,dd;
			unsigned char c,cc;
			for (c=0;c<40;c++) if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) {bd=dd; cc=c;}
			c=40+(int)floor(rr*5+0.5)+(int)floor(gg*5+0.5)*6+(int)floor(bb*5+0.5)*36;
		    if ((dd=sq(rr-r[c])+sq(gg-g[c])+sq(bb-b[c]))<bd) cc=c;
			BF_inv[n]=cc;
		}
	}
	BF_cra_loaded=1;
}

int bflength(char *s)
{
	int ret;
	if (BF_mono) return BF_monospacing*strlen(s)-1;
	else for (ret=0;*s;s++) ret+=BF_letter[c2i(*s)][0]+1;
	return ret-1;
}

BF_font *BF_makeblank(const char *handle)
{
	int n,i; char reused=0; BF_font *f;
	BF_make_cra();
	for (n=0;n<BF_numfonts && strcmpi(BF_handle[Mini(n,BF_numfonts-1)],handle);n++);
	if (n==BF_numfonts)
	{
		f=BF_array[n]=(BF_font *)mallocex(sizeof(BF_font),"BF_font structure");
		BF_handle[n]=(char *)mallocex(strlen(handle)+1,"Handle to BF_font");
		BF_numfonts++;
	}
	else
	{
		f=BF_array[n]; reused=1;
		for (i=0;i<BF_numfonts;i++) if (BF_array[i]==f && i!=n)
		{
			f=BF_array[BF_numfonts]=(BF_font *)mallocex(sizeof(BF_font),"BF_font structure");
			BF_handle[BF_numfonts]=(char *)mallocex(strlen(handle)+1,"Handle to BF_font");
			n=BF_numfonts; BF_numfonts++; i=BF_numfonts; reused=0;
		}
	}
	strcpy(BF_handle[n],handle);
	for (i=0;i<512;i++)
	{
		if (reused) free(f->letter[i]);
		if (cpp==1)
		{
			f->letter[i]=(unsigned char *)mallocex(3,"Letter in blank font (8bit)");
			f->letter[i][0]=f->letter[i][1]=1; f->letter[i][2]=1;
		}
		else
		{
			f->letter[i]=(unsigned char *)mallocex(5,"Letter in blank font (24bit)");
			f->letter[i][0]=f->letter[i][1]=1; f->letter[i][2]=f->letter[i][3]=0; f->letter[i][4]=128;
		}
	}
	f->width=1; f->height=1; f->monospacing=2;
	return f;
}

BF_font *bfsetfont(const char *handle)
{
	int n;
	BF_curfont=NULL;
	for (n=0;n<BF_numfonts && !BF_curfont;n++)
		if (!strcmpi(handle,BF_handle[n]))
		{
			BF_curfont=BF_array[n];
			BF_letter=BF_curfont->letter;
			BF_width=BF_curfont->width; BF_height=BF_curfont->height;
			BF_monospacing=BF_curfont->monospacing;
		}
	if (!BF_curfont)
	{
		if (BF_numfonts)
		{
			BF_curfont=BF_array[rnd(BF_numfonts)];
			BF_letter=BF_curfont->letter;
			BF_width=BF_curfont->width; BF_height=BF_curfont->height;
			BF_monospacing=BF_curfont->monospacing;
		}
		else
		{
			BF_curfont=BF_makeblank(handle);
			BF_letter=BF_curfont->letter;
			BF_width=BF_curfont->width; BF_height=BF_curfont->height;
			BF_monospacing=BF_curfont->monospacing;
		}
	}
	return BF_curfont;
}

void loadfont(const char *filename,const char *handle)
{
	int n,i,x,y; BF_font *f; char reused=0;
	FILE *in=fopen(filename,"rb");
	if (in)
	{
		if (BF_numfonts==0) i=0;
		else for (i=0;i<BF_numfonts && strcmpi(handle,BF_handle[Mini(i,BF_numfonts-1)]);i++);
		if (i==BF_numfonts)
		{
			#ifdef SBCLIB_DEBUG
			char desc[100]; sprintf(desc,"BF_font from '%s'",filename);
			#endif
			BF_array[i]=(BF_font *)mallocex(sizeof(BF_font),desc);
			BF_handle[i]=(char *)mallocex(strlen(handle)+1,"BF_font handle");
			BF_numfonts++;
		}
		else reused=1;
		f=BF_array[i];
		strcpy(BF_handle[i],handle);
		for (n=0;n<512;n++)
		{
			if (reused) free(f->letter[n]);
			x=fgetc(in); y=fgetc(in);
			if (!feof(in))
			{
				f->letter[n]=(unsigned char *)mallocex(2+x*y,desc);
				f->letter[n][0]=x; f->letter[n][1]=y;
				fread(f->letter[n]+2,x*y,1,in);
			}
			else
			{
				f->letter[n]=(unsigned char *)mallocex(3,"Letter off EOF");
				f->letter[n][0]=f->letter[n][1]=f->letter[n][2]=1;
			}
		}
		fclose(in);
	}
	else f=BF_makeblank(handle);
	f->width=0; for (n=0;n<512;n++) f->width=Max(f->width,f->letter[n][0]);
	f->height=0; for (n=0;n<512;n++) f->height=Max(f->height,f->letter[n][1]);
	f->monospacing=f->letter['C'][0]+1;
	bfsetfont(handle);
	BF_make_cra();
}

void bfwrite(const int ox,int y,const char *s,const unsigned c)
{
	int n,i,x=ox,nx,ny=y+BF_height-1;
	for (n=0;s[n] && x<xres;n++)
	{
		int sn=c2i(s[n]);
		if (s[n]=='\n') {x=ox; y+=BF_height+1;}
		else
		{
			nx=x+BF_letter[sn][0]-1;
			if (x>=BF_leftclipmargin && y>=0 && nx<xres && ny<yres) paintbitc(x,y,BF_letter[sn],c);
			else if (cpp==1)
			{
				int px,py,xs=BF_letter[sn][0],ys=BF_letter[sn][1];
				unsigned char *p=BF_letter[sn]+2;
				for (py=0;py<ys;py++) for (px=0;px<xs;px++,p++)
					if (x+px>=BF_leftclipmargin && x+px<xres && y+py>=0 && y+py<yres && *p && *p!=255)
						paintpix(x+px,y+py,BF_and[c][*p]);
			}
			else
			{
				int px,py,xs=BF_letter[sn][0],ys=BF_letter[sn][1];
				unsigned char *p=BF_letter[sn]+2;
				int r1=c>>16,g1=(c>>8)&0xFF,b1=c&0xFF,r2,g2,b2;
				for (py=0;py<ys;py++) for (px=0;px<xs;px++)
				{
					b2=*(p++); g2=*(p++); r2=*(p++);
					if (x+px>=BF_leftclipmargin && x+px<xres && y+py>=0 && y+py<yres
						&& (b2!=0x56 || g2!=0x34 || r2!=0x12))
						paintpix(x+px,y+py,(((r1*r2)>>8)<<16)|(((g1*g2)>>8)<<8)|((b1*b2)>>8));
				}
			}
			x=nx+2;
		}
	}
}
// END #include <bitmapfonts.c>
#include <process.h>

int nodes,links;
char **nameip=NULL;
int *ea=NULL,*eb=NULL;

void loadfilepassive(const char *filename)
{
	FILE *in=fopen(filename,"rb");
	if (in)
	{
		int n;
		if (nameip)
		{
			for (n=0;n<nodes;n++) free(nameip[n]);
			free(nameip);
		}
		fread(&nodes,sizeof(int),1,in);
		fread(&links,sizeof(int),1,in);
		nameip=(char **)malloc((nodes+1)*sizeof(char *));
		if (ea) free(ea);
		ea=(int *)malloc((links+1)*sizeof(int));
		if (eb) free(eb);
		eb=(int *)malloc((links+1)*sizeof(int));
		for (n=0;n<nodes;n++)
		{
			char str[500]; int i;
			fgets(str,500,in); if (i=strlen(str)) if (str[i-1]=='\n') str[i-1]=0;
			nameip[n]=(char *)malloc(strlen(str)+1);
			strcpy(nameip[n],str);
		}
		fread(ea,sizeof(int),links,in);
		fread(eb,sizeof(int),links,in);
		fclose(in);
	}
	else if (!nameip)
	{
		nodes=links=0;
		nameip=(char **)malloc((nodes+1)*sizeof(char *));
		ea=(int *)malloc((links+1)*sizeof(int));
		eb=(int *)malloc((links+1)*sizeof(int));
	}
}

typedef struct  // 3D rotation matrix
{
	float a11,a12,a13,
		a21,a22,a23,
		a31,a32,a33;
} M3x3;

void rotatematrix(M3x3 *p,float a,float b,float c)
{
	int n,i; M3x3 q;
	i=Max(Max(1,fabs(a*10)),Max(fabs(b*10),fabs(c*10)));
	a/=i; b/=i; c/=i;
	for (n=0;n<i;n++)
	{
		float d,e,f;
		q=*p;
		p->a11+=c*q.a21+b*q.a31; p->a21+=-c*q.a11+a*q.a31; p->a31+=-b*q.a11-a*q.a21;
		p->a12+=c*q.a22+b*q.a32; p->a22+=-c*q.a12+a*q.a32; p->a32+=-b*q.a12-a*q.a22;
		p->a13+=c*q.a23+b*q.a33; p->a23+=-c*q.a13+a*q.a33; p->a33+=-b*q.a13-a*q.a23;
		q=*p;
		a=0.5*(q.a11*q.a12+q.a21*q.a22+q.a31*q.a32);
		b=0.5*(q.a11*q.a13+q.a21*q.a23+q.a31*q.a33);
		c=0.5*(q.a12*q.a13+q.a22*q.a23+q.a32*q.a33);
		p->a11-=a*q.a12+b*q.a13; p->a12-=a*q.a11+c*q.a13; p->a13-=b*q.a11+c*q.a12;
		p->a21-=a*q.a22+b*q.a23; p->a22-=a*q.a21+c*q.a23; p->a23-=b*q.a21+c*q.a22;
		p->a31-=a*q.a32+b*q.a33; p->a32-=a*q.a31+c*q.a33; p->a33-=b*q.a31+c*q.a32;
		q=*p;
		d=sqrt(sq(q.a11)+sq(q.a21)+sq(q.a31));
		e=sqrt(sq(q.a12)+sq(q.a22)+sq(q.a32));
		f=sqrt(sq(q.a13)+sq(q.a23)+sq(q.a33));
		p->a11/=d; p->a21/=d; p->a31/=d;
		p->a12/=e; p->a22/=e; p->a32/=e;
		p->a13/=f; p->a23/=f; p->a33/=f;
	}
	// NB Chris Johnson still can't spell
}

void helpscreen()
{
	char leave=0;
	while (!leave)
	{
		bfwrite(xres/5,yres/5,"Q or Escape = Quit\n\n\
F1 = This help screen\n\n\
Arrow-keys = Rotate\n\n\
Z/X = Zoom in/Zoom out\n\n\
S = Toggle slow rotation (for use as screensaver)\n\n\
T = Toggle text display\n\n\
U = Update map from file (happens every 1 second anyway)\n\n\
Left click = Recenter display on node\n\n\
Right click = Open node's web page (if any) in Internet Explorer",15);
		bfwrite(xres/5,yres*4/5,"Press Space to continue...",34+sin(0.005*GetTickCount())*5);
		ccl(0);
		leave|=dealwithmessages()|KEY(VK_SPACE)|KEY(VK_ESCAPE)|KEY(VK_Q);
	}
}

int **rl=NULL,*rn=NULL;

void repulsionlookup()
{
	int n,i,j;
	int **al=(int **)malloc(nodes*sizeof(int *));
	for (n=0;n<nodes;n++) {al[n]=(int *)malloc(1*sizeof(int)); al[n][0]=-1;}
	for (n=0;n<links;n++)
	{
		int a=Mini(ea[n],eb[n]),b=Maxi(ea[n],eb[n]),*c;
		for (i=0;al[a][i]>=0;i++);
		c=(int *)malloc((i+2)*sizeof(int));
		memcpy(c,al[a],(i+1)*sizeof(int));
		c[i]=b; c[i+1]=-1;
		free(al[a]); al[a]=c;
	}
	if (rl) free(rl); if (rn) free(rn);
	rl=(int **)malloc(nodes*sizeof(int *)); rn=(int *)malloc(nodes*sizeof(int));
	for (n=0;n<nodes;n++) {rl[n]=(int *)malloc(1*sizeof(int)); rl[n][0]=-1; rn[n]=1;}
	for (n=0;n<nodes;n++)
	{
		int a,b,c;
		for (a=0;(i=al[n][a])>=0;a++) for (b=0;(j=al[i][nonegi(b-1)])>=0;b++) if ((j=(b?j:i))>n)
		{
			char ok=1;
			for (c=0;rl[n][c]>=0 && ok;c++) if (rl[n][c]==j) ok=0;
			if (ok)
			{
				int *d=(int *)malloc((c+2)*sizeof(int));
				memcpy(d,rl[n],(c+1)*sizeof(int));
				d[c]=j; d[c+1]=-1;
				free(rl[n]); rl[n]=d;
				rn[n]=c+1;
			}
		}
	}
	for (n=0;n<nodes;n++) free(al[n]); free(al);
}

WINMAIN
{
	int n,i,j; char str[500],iepath[500]; FILE *in,*out;
	float *x,*y,*z,*ox,*oy,*oz;
	int snode=-1;
	float zoom=5,dt=0.06,cx=0,cy=0,cz=0;
	M3x3 rot={1,0,0, 0,1,0, 0,0,1};
	double nextupdate,updateinterval=1000,gamma,progstart=0.001*GetTickCount(),nextautosave=progstart+30;
	char omb=0,slowrot=0,showtext=0,leave=0;
	srand(GetTickCount());
	//for (n=0;n<10;n++) spawnl(_P_NOWAIT,".\\netmap.exe",NULL);
	if (in=fopen(".\\prefs.txt","rt"))
	{
		fscanf(in,"Resolution: %dx%d\n",&xres,&yres);
		fscanf(in,"Gamma: %lf\n",&gamma);
		fscanf(in,"IE path: %s\n",iepath);
		fclose(in);
	}
	else
	{
		xres=800; yres=600; gamma=1.0;
	}
	makethewindow(hinst,xres,yres,"Internet Map Viewer (Stephen Brooks 2001)");
	directxsetup(); makebank(); writepal666(gamma);
	loadfont(".\\font.dat","normal");
	loadfilepassive(".\\web.dat");
	repulsionlookup();
	x=(float *)malloc(nodes*sizeof(float)); ox=(float *)malloc(nodes*sizeof(float));
	y=(float *)malloc(nodes*sizeof(float)); oy=(float *)malloc(nodes*sizeof(float));
	z=(float *)malloc(nodes*sizeof(float)); oz=(float *)malloc(nodes*sizeof(float));
	for (n=0;n<nodes;n++)
	{
		x[n]=frnd(10)-5;
		y[n]=frnd(10)-5;
		z[n]=frnd(10)-5;
	}
	if (in=fopen(".\\coords.dat","rb"))
	{
		float fx,fy,fz; i=0;
		while (!feof(in))
		{
			fgets(str,500,in);
			for (n=strlen(str);str[n-1]<32 && n>1;n--) str[n-1]=0;
			fread(&fx,sizeof(float),1,in);
			fread(&fy,sizeof(float),1,in);
			fread(&fz,sizeof(float),1,in);
			for (j=0;j<nodes;i=(i+1)%nodes,j++) if (!strcmpi(str,nameip[i]))
			{
				x[i]=fx; y[i]=fy; z[i]=fz;
				j=nodes;
			}
		}
		fclose(in);
	}
	nextupdate=GetTickCount();
	while (!leave)
	{
		double framestart=GetTickCount();

		if (snode>=0)
		{
			cx=cx*0.9+x[snode]*0.1;
			cy=cy*0.9+y[snode]*0.1;
			cz=cz*0.9+z[snode]*0.1;
		}
		memcpy(ox,x,nodes*sizeof(float));
		memcpy(oy,y,nodes*sizeof(float));
		memcpy(oz,z,nodes*sizeof(float));
		for (n=0;n<links;n++)
		{
			int a=ea[n],b=eb[n],c=1;//Maxi(rn[a],rn[b]);
			float dx=dt*(ox[b]-ox[a])/c,dy=dt*(oy[b]-oy[a])/c,dz=dt*(oz[b]-oz[a])/c;
			x[a]+=dx; y[a]+=dy; z[a]+=dz;
			x[b]-=dx; y[b]-=dy; z[b]-=dz;
		}
		for (n=0;n<nodes;n++)
		{
			for (j=0;(i=rl[n][j])>=0;j++)
			{
				float dx=ox[i]-ox[n],dy=oy[i]-oy[n],dz=oz[i]-oz[n],dd=dx*dx+dy*dy+dz*dz+0.001;
				dd=dt/dd;///Maxi(rn[n],rn[i]);
				dx*=dd; dy*=dd; dz*=dd;
				x[n]-=dx; y[n]-=dy; z[n]-=dz;
				x[i]+=dx; y[i]+=dy; z[i]+=dz;
			}
			for (j=0;j<10;j++)
			{
				i=rnd(nodes);
				float dx=ox[i]-ox[n],dy=oy[i]-oy[n],dz=oz[i]-oz[n],dd=dx*dx+dy*dy+dz*dz+0.001;
				dd=dt/dd;///Maxi(rn[n],rn[i]);
				dx*=dd; dy*=dd; dz*=dd;
				x[n]-=dx; y[n]-=dy; z[n]-=dz;
				x[i]+=dx; y[i]+=dy; z[i]+=dz;
			}
		}
		for (n=0;n<links;n++)
		{
			int a=ea[n],b=eb[n];
			line(((x[a]-cx)*rot.a11+(y[a]-cy)*rot.a12+(z[a]-cz)*rot.a13)*zoom+xres/2,
				((x[a]-cx)*rot.a21+(y[a]-cy)*rot.a22+(z[a]-cz)*rot.a23)*zoom+yres/2,
				((x[b]-cx)*rot.a11+(y[b]-cy)*rot.a12+(z[b]-cz)*rot.a13)*zoom+xres/2,
				((x[b]-cx)*rot.a21+(y[b]-cy)*rot.a22+(z[b]-cz)*rot.a23)*zoom+yres/2,7);
		}
		for (n=0;n<nodes;n++)
		{
			int px=((x[n]-cx)*rot.a11+(y[n]-cy)*rot.a12+(z[n]-cz)*rot.a13)*zoom+xres/2,
				py=((x[n]-cx)*rot.a21+(y[n]-cy)*rot.a22+(z[n]-cz)*rot.a23)*zoom+yres/2;
			char on=(sq(mx-px)+sq(my-py)<50);
			orpix(px,py,32); orpix(px+1,py,32); orpix(px-1,py,32); orpix(px,py+1,32); orpix(px,py-1,32);
			if (showtext || n==snode || on || n==0) bfwrite(px+8,py-BF_height/2,nameip[n],(n==0)?11:(n==snode)?13:(sq(mx-px)+sq(my-py)<30?10:2));
			if (on)
			{
				circle(px,py,4,9);
				if ((mb&1) && !(omb&1)) snode=n;
				if ((mb&2) && !(omb&2))
				{
					minimise_window=1; mb&=~2;
					sprintf(str," http://%s/",nameip[n]);
					for (i=1;str[i];i++) if (str[i]==' ') {str[i]='/'; str[i+1]=0;}
					spawnl(_P_NOWAIT,iepath,str,NULL);
					mb=omb=0;
				}
			}
			if (n==snode) circle(px,py,3,5);
		}

		sprintf(str,"%d nodes",nodes);
		bfwrite(0,yres-BF_height*3,str,14);
		sprintf(str,"%d links",links);
		bfwrite(0,yres-BF_height,str,14);
		if (0.001*GetTickCount()<progstart+10) bfwrite(xres*2/3,yres-BF_height*2,"Press F1 for help",11);
		if (KEY(VK_F1)) helpscreen();
		if (KEY(VK_LEFT)) rotatematrix(&rot,0,0.1,0);
		if (KEY(VK_RIGHT)) rotatematrix(&rot,0,-0.1,0);
		if (KEY(VK_UP)) rotatematrix(&rot,0.1,0,0);
		if (KEY(VK_DOWN)) rotatematrix(&rot,-0.1,0,0);
		if (KEY(VK_Z)) zoom*=1.1;
		if (KEY(VK_X)) zoom/=1.1;
		if (KHIT(VK_S)) slowrot^=1;
		if (slowrot) rotatematrix(&rot,0,0.005,0);
		if (KHIT(VK_T)) showtext^=1;
		if (KHIT(VK_U) || GetTickCount()>=nextupdate)
		{
			int om=nodes; float *nx,*ny,*nz;
			loadfilepassive(".\\web.dat");
			if (nodes!=om)
			{
				repulsionlookup();
				free(ox); free(oy); free(oz);
				ox=(float *)malloc(nodes*sizeof(float));
				oy=(float *)malloc(nodes*sizeof(float));
				oz=(float *)malloc(nodes*sizeof(float));
				nx=(float *)malloc(nodes*sizeof(float));
				ny=(float *)malloc(nodes*sizeof(float));
				nz=(float *)malloc(nodes*sizeof(float));
				memcpy(nx,x,om*sizeof(float));
				memcpy(ny,y,om*sizeof(float));
				memcpy(nz,z,om*sizeof(float));
				free(x); x=nx; free(y); y=ny; free(z); z=nz;
				for (n=om;n<nodes;n++)
				{
					x[n]=frnd(10)-5;
					y[n]=frnd(10)-5;
					z[n]=frnd(10)-5;
				}
			}
			nextupdate+=updateinterval;
		}
		// Top "Windows" buttons
		{
			char on;
			on=(mx>=xres-15 && my<=14);
			box(xres-15,0,14,14,n=40+2*6+5*36+on*(2+2*6)); box(xres-14,1,12,12,n);
			line(xres-12,3,xres-4,11,n); line(xres-12,4,xres-5,11,n); line(xres-11,3,xres-4,10,n);
			line(xres-12,11,xres-4,3,n); line(xres-12,10,xres-5,3,n); line(xres-11,11,xres-4,4,n);
			if (on && (mb&1)) leave=1;
			on=(mx>=xres-31 && mx<=xres-17 && my<=14);
			box(xres-31,0,14,14,n=40+2*6+5*36+on*(2+2*6)); box(xres-30,1,12,12,n);
			line(xres-28,11,xres-20,11,n); line(xres-28,10,xres-20,10,n);
			if (on && (mb&1) && !(omb&1)) minimise_window=1;
			on=(mx>=xres-55 && mx<=xres-41 && my<=14);
			box(xres-55,0,14,14,n=40+3*6+1*36+on*(2*6+2*36)); box(xres-54,1,12,12,n);
			rect(xres-52,10,4,2,n); rect(xres-51,3,2,8,n); rect(xres-51,3,8,2,n); rect(xres-45,3,2,4,n);
			if (on && (mb&1)) writepal666(gamma*=1.05);
			if (on && (mb&2)) writepal666(gamma/=1.05);
			gamma=Min(Max(gamma,0.1),10);
			/*
			on=(mx>=xres-79 && mx<=xres-65 && my<=14);
			box(xres-79,0,14,14,n=40+3+1*6+on*(2+2*6)); box(xres-78,1,12,12,n);
			rect(xres-73,4,3,4,n); line(xres-72,3,xres-72,8,n); rect(xres-73,10,3,2,n);
			if (on && (mb&1)) leave=2;
			*/
		}
		line(mx,my,mx+4,my+4,15); line(mx,my,mx+2,my,15); line(mx,my,mx,my+2,15);
		ccl(0);
if (0.001*GetTickCount()>nextautosave)
{
	out=fopen(".\\coords.dat","wb");
	nextupdate=GetTickCount()+12;
	for (n=i=leave=0;n<nodes && !leave;n++)
	{
		if (n>i)
		{
			if (GetTickCount()>nextupdate)
			{
				sprintf(str,"Saving mesh... %d%%",100*n/nodes);
				bfwrite((xres-bflength(str))/2,(yres-BF_height)/2,str,15);
				ccl(0);
				leave|=dealwithmessages()|KEY(VK_Q)|KEY(VK_ESCAPE);
				nextupdate=GetTickCount()+12;
			}
			i+=nodes/100;
		}
		fputs(nameip[n],out); fputc('\n',out);
		fwrite(x+n,sizeof(float),1,out);
		fwrite(y+n,sizeof(float),1,out);
		fwrite(z+n,sizeof(float),1,out);
	}
	fclose(out);
	nextautosave+=30;
}
		omb=mb;
		do leave|=KEY(VK_Q)|KEY(VK_ESCAPE)|dealwithmessages();
		while (GetTickCount()<=framestart+12 && !leave);
	}
	out=fopen(".\\prefs.txt","wt");
	fprintf(out,"Resolution: %dx%d\nGamma: %f\nIE path: %s\n",xres,yres,gamma,iepath);
	fclose(out);
	out=fopen(".\\coords.dat","wb");
	nextupdate=GetTickCount()+12;
	for (n=i=leave=0;n<nodes && !leave;n++)
	{
		if (n>i)
		{
			if (GetTickCount()>nextupdate)
			{
				sprintf(str,"Saving mesh... %d%%",100*n/nodes);
				bfwrite((xres-bflength(str))/2,(yres-BF_height)/2,str,15);
				ccl(0);
				leave|=dealwithmessages()|KEY(VK_Q)|KEY(VK_ESCAPE);
				nextupdate=GetTickCount()+12;
			}
			i+=nodes/100;
		}
		fputs(nameip[n],out); fputc('\n',out);
		fwrite(x+n,sizeof(float),1,out);
		fwrite(y+n,sizeof(float),1,out);
		fwrite(z+n,sizeof(float),1,out);
	}
	fclose(out);
	return 0;
}
