#include <rnd.c>
#include <lset.c>

typedef struct {unsigned ip; char *name;} Node;
typedef struct {int a,b;} Link; // a,b are indexes in the nodes LSet

typedef struct
{
	LSet nodes,links;
	Node *na; Link *la;
} Database;

Database *newdb()
{
	Database *d=(Database *)malloc(sizeof(Database));
	d->nodes=LSet(Node); d->links=LSet(Link);
	LSet_hookup(&d->nodes,&d->na);
	LSet_hookup(&d->links,&d->la);
	return d;
}

void cleardb(Database *d)
{
	for (int n=d->nodes.m-1;n>=0;n--) free(d->na[n].name);
	LSet_clear(&d->nodes);
	LSet_clear(&d->links);
}

void freedbptr(Database *d)
{
	cleardb(d);
	LSet_free(d->nodes); LSet_free(d->links);
	free(d);
}

#ifdef SBCLIB_BITMAPFONTS
void report(const char *s)
{
	static unsigned long lastupd=0;
	if (GetTickCount()>lastupd+50)
	{
		rect(0,(yres-BF_height)/2-1,xres,BF_height+2,0);
		bfwrite((xres-bflength(s))/2,(yres-BF_height)/2,s,(cpp==1?15:0xFFFFFF));
		update();
		lastupd=GetTickCount();
	}
}
#endif

Database *loadfile(const char *filename,unsigned long *psize)
{
	Database *d=newdb();
	FILE *in=fopen(filename,"rb");
	if (in)
	{
		int mn,ml; char str[1000];
		fread(&mn,sizeof(int),1,in);
		fread(&ml,sizeof(int),1,in);
		for (int n=0;n<mn;n++)
		{
			Node c;
			fread(&c.ip,sizeof(unsigned),1,in);
			c.name=NULL; fgetstr(&c.name,in,"");
			LSet_add(&d->nodes,&c);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Loading %s: %d nodes",filename,n);
	report(str);
}
#endif
		}
		for (int n=0;n<ml;n++)
		{
			Link e;
			fread(&e.a,sizeof(int),1,in);
			fread(&e.b,sizeof(int),1,in);
			LSet_add(&d->links,&e);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Loading %s: %d links",filename,n);
	report(str);
}
#endif
		}
		if (psize) *psize=ftell(in);
		fclose(in);
	}
	else if (psize) *psize=0;
	return d;
}

unsigned long savefile(Database *d,const char *filename)
{
	unsigned long ret=0;
	int n; FILE *out=fopen(filename,"wb");
	fwrite(&d->nodes.m,sizeof(int),1,out);
	fwrite(&d->links.m,sizeof(int),1,out);
	for (n=0;n<d->nodes.m;n++)
	{
		fwrite(&d->na[n].ip,sizeof(unsigned),1,out);
		fputstr(d->na[n].name,out);
	}
	for (n=0;n<d->links.m;n++)
	{
		fwrite(&d->la[n].a,sizeof(int),1,out);
		fwrite(&d->la[n].b,sizeof(int),1,out);
	}
	ret=ftell(out);
	fclose(out);
	return ret;
}

int getindex(Database *d,const unsigned ip)
{
	for (int n=d->nodes.m-1;n>=0;n--) if (ip==d->na[n].ip) return n;
	return -1;
}

int ismapped(Database *d,const unsigned ip)
{
	return getindex(d,ip)>=0;
}

void addipname(Database *d,const unsigned ip,const char *s)
{
	if (ismapped(d,ip)) return;
	Node c; c.ip=ip;
	streqi(&c.name,s);
	LSet_add(&d->nodes,&c);
}

void addlink(Database *d,const unsigned ip1,const unsigned ip2)
{
	int x1=getindex(d,ip1);
	if (x1<0) return;
	int x2=getindex(d,ip2);
	if (x2<0) return;
	if (x1==x2) return;
	Link *la=d->la;
	for (int n=d->links.m-1;n>=0;n--)
		if (la[n].a==x1) {if (la[n].b==x2) return;}
		else if (la[n].a==x2) {if (la[n].b==x1) return;}
	Link e;
	e.a=x1; e.b=x2;
	LSet_add(&d->links,&e);
}

void mergefile(Database *d,const char *filename)
{
	int n; Database *e=loadfile(filename,NULL);
	Node *na=e->na; Link *la=e->la;
	for (n=e->nodes.m-1;n>=0;n--)
	{
		addipname(d,na[n].ip,na[n].name);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Merging %s... %d nodes remaining",filename,n);
	report(str);
}
#endif
	}
	for (n=e->links.m-1;n>=0;n--)
	{
		addlink(d,na[la[n].a].ip,na[la[n].b].ip);
#ifdef SBCLIB_BITMAPFONTS
if (n%100==0)
{
	char str[100];
	sprintf(str,"Merging %s... %d links remaining",filename,n);
	report(str);
}
#endif
	}
	freedbptr(e);
}


