void main()
{
	srand(GetTickCount()); _setcursortype(_NOCURSOR);
	short subnet[4]={-1,-1,-1,-1};
	FILE *in=fopen("subnet.txt","rt");
	if (in)
	{
		char *s=NULL,**e;
		fgetstr(&s,in,"\n\r"); fclose(in);
		printf("Searching within %s\n",s);
		e=explode(".",s);
		for (int n=0;n<4;n++) if (strcmp(e[n],"*"))
			subnet[n]=atoi(e[n]);
		explodefree(e); free(s);
	}
	// Start Winsock up
	WSADATA wsaData;
	if (WSAStartup(MAKEWORD(2,1),&wsaData)!=0) {errr("Failed to find Winsock 2.1 or better."); return;}
	unsigned long nextsave=GetTickCount()+saveinterval*1000,cursize;
	USHORT seq_base=0;
	char webfile[100]; sprintf(webfile,"%s.dat",basefilename);
	Database *db=loadfile(webfile,&cursize);
	unsigned char *f=(unsigned char *)malloc(steps);
	while (1)
	{
		unsigned ip; int om=db->nodes.m; TrialType gen;
		do
		{
			if (!rnd(10) || om<100)
			{
				ip=IP(rnd(256),rnd(256),rnd(256),rnd(256));
				gen=Random;
			}
			else if (rnd(2))
			{
				int n=rnd(om),i=3-rnd(1+rnd(4)); // Concentrates on subnets
				ip=db->na[n].ip;
				ip=(ip&~(0xFF<<(i<<3)))|(rnd(256)<<(i<<3));
				gen=Mutate;
			}
			else
			{
				Node *na=db->na;
				ip=(na[rnd(om)].ip&0xFF)|
					(na[rnd(om)].ip&0xFF00)|
					(na[rnd(om)].ip&0xFF0000)|
					(na[rnd(om)].ip&0xFF000000);
				gen=Crossover;
			}
		} while (ismapped(db,ip));
		//ip=(ip&0xFFFF0000)|0xF682;
		for (int n=0;n<4;n++) if (subnet[n]>=0) // Apply subnet mask (if any)
			ip=(ip&~(0xFF<<(n*8)))|(subnet[n]<<(n*8));
		unsigned *p=gettracevector(ip,steps,seq_base);
		gotoxy(1,3); printf("Impressive-looking hex codes:");
		memset(f,0,steps); char blank=1;
		for (int n=0;n<steps;n++)
		{
			unsigned ip=p[n];
			if (ip) blank=0;
			gotoxy(n/20*20+2,n%20+5);
			if (ip && !ismapped(db,ip)) {printf("* %08X *",ip); f[n]=1; for (int i=n-1;i>=0;i--) if (p[i]==ip) f[i]=0;}
			else if (ip) printf("  %08X  ",ip);
			else printf("  --------  ");
		}
		for (int n=steps-1;n>=0;n--) if (f[n])
		{
			unsigned ip=p[n];
			struct hostent *he=gethostbyaddr((char *)&ip,4,AF_INET);
			if (he) addipname(db,ip,he->h_name); // he==NULL if there is no DNS name
			else addipname(db,ip,"");
			statusreport(db->nodes.m,db->links.m,nextsave,cursize);
		}
		for (int n=steps-2;n>=0;n--)
		{
			unsigned a=p[n],b=p[n+1];
			if (a && b) addlink(db,a,b);
		}
		free(p);
		if (GetTickCount()>nextsave) {cursize=savefile(db,webfile); nextsave+=saveinterval*1000;}
		statusreport(db->nodes.m,db->links.m,nextsave,cursize);
		EnumWindows(title_cb,db->nodes.m);
		//if (!blank) efficiencyreport(gen,db->nodes.m-om);
	}
	free(f); freedbptr(db);
	freedbptr(db);
	// Get rid of Winsock again
	WSACleanup();
}

/*WINMAIN
{
	// Start Winsock up
	WSADATA wsaData;
	if (WSAStartup(MAKEWORD(2,1),&wsaData)!=0) {errr("Failed to find Winsock 2.1 or better."); return;}
	int steps=50;
	GRAPHICS(800,600,"Fast Ping test (Stephen Brooks, Chris Johnson 2002)");
	int x=0,y=0;
	LOOP
	{
		unsigned *p=gettracevector(IP(rnd(256),rnd(256),rnd(256),rnd(256)),steps);
		for (int q=0;q<steps;q++)
		{
			if (p[q]==0) for (int xx=0;xx<8;xx++) putpix(x+xx,y+q*2+xx%2,7);
			else for (int b=0;b<4;b++) rect(x+b*2,y+q*2,2,2,(p[q]>>(b*8))&0xFF);
		}
		free(p); x+=10; if (x>xres) {x=0; y+=steps*2+5;}
		update();
	}
	// Get rid of Winsock again
	WSACleanup();
}*/

