//#define COMMANDLINE
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <time.h>

double dbl(const LARGE_INTEGER x)
{
	return (double)x.HighPart*4294967296.0+x.LowPart;
}

double eithertime()
{
	LARGE_INTEGER f;
	if (QueryPerformanceFrequency(&f))
	{
		LARGE_INTEGER t;
		QueryPerformanceCounter(&t);
		return dbl(t)/dbl(f);
	}
	else return 0.001*GetTickCount();
}

void uptime(const int y)
{
	double t=eithertime();
	gotoxy(1,y); textcolor(12);
	int dy=floor(t/86400),hr=floor(t/3600),mn=((unsigned)floor(t/60))%60,
		sc=((unsigned)floor(t))%60,ms=floor(fmod(t*1000,1000));
	if (t<86400) printf("%d:%02d:%02d.%03d",hr,mn,sc,ms);
	else printf("%d day%s %02d:%02d:%02d.%03d",dy,(dy==1?"":"s"),hr%24,mn,sc,ms);
	gotoxy(30,y); textcolor(3);
	printf("%.2f hours",t/3600.0);
	gotoxy(50,y); textcolor(2);
	printf("%08X",GetTickCount());
	LARGE_INTEGER qt;
	if (QueryPerformanceCounter(&qt))
	{
		gotoxy(60,y); textcolor(7);
		printf("%08X:%08X",qt.HighPart,qt.LowPart);
	}
}

void main()
{
#ifdef COMMANDLINE
	uptime(wherey());
	textcolor(7);
#else
	_setcursortype(_NOCURSOR);
	while (!kbhit()) uptime(1);
#endif
}
