#ifndef FL2C0_optimsteepest
#include <FL2/C0/problem.c>
#include <squarematrix.c>
#include <rnd/cu.c>

void FL2Problem_steepest(FL2Problem *p,REAL *a,REAL *plambda)
{
	int n,i,m=p->am;
	REAL *scratch=array_1d(p->bm);
	REAL *b=array_1d(m),eref=FL2Problem_evalerrornorm(p,a,scratch);
	memcpy(b,a,m*sizeof(REAL));
	REAL *o,**rm=FL2Problem_response(p,a,&o);
	REAL *u=matrixtmulvector(rm,o);
	array_1d_free(o); array_2d_free(rm);
	REAL bl=-1,e,be=eref;
	for (n=-10;n<=10;n++)
	{
		REAL l=*plambda*pow(1e6,cu(0.1*n));
	   	for (i=m-1;i>=0;i--) b[i]=a[i]-l*u[i];
   		e=FL2Problem_evalerrornorm(p,b,scratch);
   		if (e<be) {be=e; bl=l;}
	}
	array_1d_free(b); array_1d_free(scratch);
	if (be<eref) for (n=m-1;n>=0;n--) {a[n]-=bl*u[n]; *plambda=bl;}
	array_1d_free(u); 
}

#define FL2C0_optimsteepest
#endif
