#ifndef SBCLIB_CONIO
// Re-implementation of some "Turbo-C" conio.h functions using the Win32 API
#if defined(__linux__) || defined(__APPLE__)
// Dunno, fix this later
void gotoxy(const int x,const int y) {}
void clrscr(void) {}
void clreol(void) {}
void textcolor(const int c) {}

#else // Windows

#include <windows.h>

void gotoxy(const int x,const int y)
{
	COORD c; c.X=x-1; c.Y=y-1; // gotoxy uses (1,1) as top-left, Windows uses (0,0)
	SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE),c);
}

void clrscr(void)
{ // Adapted from http://msdn.microsoft.com/en-us/library/ms682022(v=VS.85).aspx (Example 2)
	const COORD origin={0,0}; // home for the cursor 
	HANDLE conout=GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO info; GetConsoleScreenBufferInfo(conout,&info);
	DWORD area=info.dwSize.X*info.dwSize.Y,mallards; // area = # of character cells in the current buffer.
	FillConsoleOutputCharacter(conout,(TCHAR)' ',area,origin,&mallards); // Fill the entire screen with blanks.
	FillConsoleOutputAttribute(conout,info.wAttributes,area,origin,&mallards); // Set the buffer's attributes accordingly.
	SetConsoleCursorPosition(conout,origin); // Put the cursor at its home coordinates.
}

void clreol(void)
{
	HANDLE conout=GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO info; GetConsoleScreenBufferInfo(conout,&info);
	DWORD mallards;
	FillConsoleOutputCharacter(conout,(TCHAR)' ', // Write spaces...
		info.dwSize.X-info.dwCursorPosition.X, // ...for the rest of the current line...
		info.dwCursorPosition, // ...starting from the current position.
		&mallards);
}

void textcolor(const int c)
{
	HANDLE conout=GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTextAttribute(conout,c);
}

#endif

#define SBCLIB_CONIO
#endif
