#ifndef SBCLIB_RND_drnd
// Deterministic random number generator, takes about 2x as long as calling rnd
#include <math.h>

#ifdef DRND_RND_TEST
// Switch to replace drnd by old style random number generator, check for differences
#include <rnd/rnd.c>
#define DRND_ALG(seed,seq,a,b) \
	unsigned a=(rnd(65536)<<16)|rnd(65536),b=(rnd(65536)<<16)|rnd(65536);

#else
// Normal version
#define DRND_STAGE(seed,seq,a,b) \
	a+=seed; b+=seq; \
	a*=b; b*=a; \
	a+=b>>16; b+=a>>16;

#endif

#ifdef DRND_LOGGING // I'm a lumberjack and I'm OK
// Switch to log the seeds and sequence values used by the application (allows checking for collisions)
#define DRND_ALG(seed,seq,a,b) \
	unsigned a=0x01234567,b=0x89ABCDEF; \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	FILE *out=fopen("drnd.log","at"); fprintf(out,"(%u,%u) --> %08X %08X\n",seed,seq,a,b); fclose(out);

#else

#define DRND_ALG(seed,seq,a,b) \
	unsigned a=0x01234567,b=0x89ABCDEF; \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b) \
	DRND_STAGE(seed,seq,a,b)

#endif

const double TWONEG32=1.0F/65536/65536;

unsigned drnd(const unsigned lim,const unsigned seed,const unsigned seq)
{ // Random int on 0..lim-1
	DRND_ALG(seed,seq,a,b);
	return (unsigned)floor((b*TWONEG32+a)*TWONEG32*lim);
}

unsigned drnda(const unsigned seed,const unsigned seq)
{ // Raw random 0 to 0xFFFFFFFF
	DRND_ALG(seed,seq,a,b);
	return a;
}

unsigned drndb(const unsigned seed,const unsigned seq)
{ // Raw random 0 to 0xFFFFFFFF
	DRND_ALG(seed,seq,a,b);
	return b;
}

#define SBCLIB_RND_drnd
#endif
