#ifndef SBCLIB_RND_VARNUM
#include <stdio.h>
// Routines for reading and writing variable-length numbers (to FILE and to RAM)
// 32-bit unsigned interface for now, should add switches for uint64_t etc.

void fwritenum(unsigned n,FILE *out)
{ // Use binary mode "wb"
	static unsigned char buf[10];
	int i=0;
	do {buf[i]=n&0x7F; n>>=7; i++;} while (n); // Do-while so that n=0 still use 1 byte
	buf[i-1]|=0x80;
	fwrite(buf,1,i,out);
}

void writenum(unsigned n,unsigned char **pb)
{ // To RAM
	unsigned char *b=*pb;
	do {*b=n&0x7F; n>>=7; b++;} while (n); // Do-while so that n=0 still use 1 byte
	b[-1]|=0x80;
	*pb=b;
}

unsigned freadnum(FILE *in)
{ // Use binary mode "rb"
	unsigned ret=0,s=0,c;
	do {c=fgetc(in); ret+=(c&0x7F)<<s; s+=7;} while (c<0x80);
	return ret;
}

unsigned readnum(unsigned char **pa)
{ // Use binary mode "rb"
	unsigned ret=0,s=0,c; unsigned char *a=*pa;
	do {c=*a; a++; ret+=(c&0x7F)<<s; s+=7;} while (c<0x80);
	*pa=a;
	return ret;
}

unsigned numpackint(const int n) /**/ // Nice idea, corner cases need testing
{
	if (n>=0) return ((unsigned)n)*2;
	else return ((unsigned)-n)*2-1;
}

int numunpackint(const unsigned n)
{
	if (n&1) return -((int)(n/2)+1);
	else return n/2;
}

/**/ // Could do versions for (lossless) compact double and float?

#define SBCLIB_RND_VARNUM
#endif
