#ifndef SBCLIB_V2
#include <math.h>

#define V2template(VT,ET) \
\
typedef struct {ET x,y;} VT; \
\
const VT VT##_zero={0,0}; \
\
VT VT##_new(const ET x,const ET y) \
{ \
	VT ret; \
	ret.x=x; ret.y=y; \
	return ret; /* Hardly exciting */ \
} \
\
int operator ==(const VT a,const VT b) \
{ \
	return a.x==b.x && a.y==b.y; \
} \
\
int operator !=(const VT a,const VT b) \
{ \
	return a.x!=b.x || a.y!=b.y; \
} \
VT operator +(VT a,const VT b) \
{ \
	a.x+=b.x; a.y+=b.y; \
	return a; \
} \
\
VT operator +=(VT &a,const VT b) \
{ \
	a.x+=b.x; a.y+=b.y; \
	return a; \
} \
\
VT operator -(VT a,const VT b) \
{ \
	a.x-=b.x; a.y-=b.y; \
	return a; \
} \
\
VT operator -(VT a) \
{ \
	a.x=-a.x; a.y=-a.y; \
	return a; \
} \
\
VT operator -=(VT &a,const VT b) \
{ \
	a.x-=b.x; a.y-=b.y; \
	return a; \
} \
\
VT operator *(const ET t,VT a) \
{ \
	a.x*=t; a.y*=t; \
	return a; \
} \
\
VT operator *(VT a,const ET t) \
{ \
	a.x*=t; a.y*=t; \
	return a; \
} \
\
VT operator *=(VT &a,const ET t) \
{ \
	a.x*=t; a.y*=t; \
	return a; \
} \
\
VT operator /(const VT a,const int b) \
{ \
	VT ret; \
	ret.x=a.x/b; ret.y=a.y/b; \
	return ret; \
} \
\
VT operator /(const VT a,const ET b) \
{ \
	VT ret; \
	ret.x=a.x/b; ret.y=a.y/b; \
	return ret; \
} \
\
VT operator /=(VT &a,const ET b) \
{ \
	a.x/=b; a.y/=b; \
	return a; \
} \
\
VT operator /=(VT &a,const int b) \
{ \
	a.x/=b; a.y/=b; \
	return a; \
} \
\
ET operator *(const VT a,const VT b) \
{ /* Vector dot product */ \
	return a.x*b.x+a.y*b.y; \
} \
\
ET operator ^(const VT a,const VT b) \
{ /* Vector cross product */ \
	return a.x*b.y-a.y*b.x; \
} \
\
ET VT##_dd(const VT a,const VT b) \
{ \
	return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y); \
} \
\
ET VT##_dist(const VT a,const VT b) \
{ \
	return sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y)); \
} \
\
VT VT##_normalise(VT a) \
{ \
	ET k=1.0/sqrt(a.x*a.x+a.y*a.y); \
	a.x*=k; a.y*=k; \
	return a; \
} \
\
ET VT##_norm(const VT a) \
{ \
	return sqrt(a.x*a.x+a.y*a.y); \
} \
\
ET VT##_normsq(const VT a) \
{ \
	return a.x*a.x+a.y*a.y; \
} \
\
VT VT##_min(VT a,const VT b) \
{ \
	if (b.x<a.x) a.x=b.x; \
	if (b.y<a.y) a.y=b.y; \
	return a; \
} \
\
VT VT##_max(VT a,const VT b) \
{ \
	if (b.x>a.x) a.x=b.x; \
	if (b.y>a.y) a.y=b.y; \
	return a; \
} \
\
VT VT##_direction(const ET th) \
{ \
	VT ret; ret.x=cos(th); ret.y=sin(th); return ret; \
} \
\
VT VT##_polar(const ET r,const ET th) \
{ \
	VT ret; ret.x=r*cos(th); ret.y=r*sin(th); return ret; \
} \
\
VT VT##_rotateright(const VT a,const int r) \
{ \
	switch (r&3) \
	{ \
		case 0: return a; \
		case 1: return VT##_new(a.y,-a.x); \
		case 2: return -a; \
		case 3: return VT##_new(-a.y,a.x); \
	} \
	return VT##_zero; \
} \
\
VT VT##_rotate(const VT a,const ET th) \
{ \
	ET c=cos(th),s=sin(th); VT ret; \
	ret.x=c*a.x-s*a.y; ret.y=s*a.x+c*a.y; \
	return ret; \
}

V2template(V2,double);

#define SBCLIB_V2
#endif
