#include <FL2/C0/optimsteepest.c>
#include <FL2/C0/optimsvd.c>

typedef struct
{
	LSet goals; // LSet(GoalField)
	Magnet (*magfromparams)(const REAL *); // This takes an array_1d not a flat C array
} MagnetProblem;

void MagnetProblem_free(MagnetProblem *p)
{ // Also frees GoalFields
	GoalField *g=(GoalField *)p->goals.a;
	for (int n=p->goals.m-1;n>=0;n--) GoalField_free(g[n]);
	LSet_free(&p->goals);
}

/* // Old single-coil version
void Magnet_rotatingcoil_interleaved_FL2(const REAL *a,const int am,REAL *b,const int bm,MagnetProblem *p)
{
	int n,pm=bm/2;
	REAL *aa=array_1d(am); memcpy(aa,a,am*sizeof(REAL));
	Magnet mag=p->magfromparams(aa);
	array_1d_free(aa);
	REAL *x=Magnet_rotatingcoil_interleaved(mag,p->goal.gfc,p->goal.gfr,pm),
		*g=GoalField_coil(p->goal); // These might be different lengths
	Magnet_free(mag);
	if (array_1d_m(g)<bm) // g is shorter, pad with zeroes
	{
		REAL *ng=array_1d_zeroed(bm);
		memcpy(ng,g,array_1d_m(g)*sizeof(REAL));
		array_1d_free(g); g=ng;		
	}
	if (array_1d_m(x)!=array_1d_m(g) || array_1d_m(x)!=bm || array_1d_m(g)!=bm)
	{
		char str[200]; sprintf(str,"optimise.c: disagreement x[] has length %d, g[] has length %d, bm=%d",array_1d_m(x),array_1d_m(g),bm);
		reportfatala(str);
	}
	for (n=bm-1;n>=0;n--) b[n]=x[n]-g[n];
	array_1d_free(x); array_1d_free(g);
} */

void Magnet_rotatingcoils_interleaved_FL2(const REAL *a,const int am,REAL *b,const int bm,MagnetProblem *p)
{
	int n,i,gm=p->goals.m,pm=bm/gm/2,bofs=0;
	REAL *aa=array_1d(am); memcpy(aa,a,am*sizeof(REAL));
	Magnet mag=p->magfromparams(aa); GoalField *gf=(GoalField *)p->goals.a;
	array_1d_free(aa);
	for (n=0;n<gm;n++)
	{
		REAL *x=Magnet_rotatingcoil_interleaved(mag,gf[n].gfc,gf[n].gfr,pm),
			*g=GoalField_coil(gf[n]); // These might be different lengths
		if (array_1d_m(g)<pm*2) // g is shorter, pad with zeroes
		{
			REAL *ng=array_1d_zeroed(pm*2);
			memcpy(ng,g,array_1d_m(g)*sizeof(REAL));
			array_1d_free(g); g=ng;
		}
		if (array_1d_m(x)!=array_1d_m(g))
		{
			char str[200]; sprintf(str,"optimise.c: coil %d/%d disagreement x[] has length %d, g[] has length %d, pm*2=%d, bm=%d",
				n,gm,array_1d_m(x),array_1d_m(g),pm*2,bm);
			reportfatala(str);
		}
		if (bofs+array_1d_m(x)>bm)
		{
			char str[200]; sprintf(str,"optimise.c: coil %d/%d trying to fill to length %d but bm=%d",
				n,gm,bofs+array_1d_m(x),bm);
			reportfatala(str);
		}
		for (i=array_1d_m(x)-1;i>=0;i--) b[bofs+i]=x[i]-g[i];
		bofs+=array_1d_m(x);
		array_1d_free(x); array_1d_free(g);
	}
	if (bofs<bm)
	{
		char str[200]; sprintf(str,"optimise.c: %d coils only filled to length %d but bm=%d",
			gm,bofs,bm);
		reportfatala(str);
	}
	Magnet_free(mag);
}

REAL optimise_area_weight=0.25; // Teslas (at coil radius) per square meter I think (or Gauss per cm^2)

void Magnet_rotatingcoils_interleaved_area_FL2(const REAL *a,const int am,REAL *b,const int bm,MagnetProblem *p)
{
	Magnet_rotatingcoils_interleaved_FL2(a,am,b,bm-1,p);
	REAL *aa=array_1d(am); memcpy(aa,a,am*sizeof(REAL));
	Magnet mag=p->magfromparams(aa);
	b[bm-1]=Magnet_area(mag)*optimise_area_weight; // Area weight factor: adjustable
	// Used 0.5 for CEBAF small-scale(R5mm) v4 magnets, going lower for R10mm clearances
	array_1d_free(aa);
	Magnet_free(mag);
}

V2 (*Magnet_errorset_field)(V2)=NULL; // The difference between measured fields and the design

void Magnet_midplanefield_FL2(const REAL *a,const int am,REAL *b,const int bm,MagnetProblem *p)
{
	V2 b0,b1; GoalFields_bb(&p->goals,&b0,&b1);
	if (bm%2) reportfatal("optimise.c: bm not multiple of 2 in Magnet_midplanefield_FL2");
	int n,m=bm/2; V2 x,e;
	REAL *aa=array_1d(am); memcpy(aa,a,am*sizeof(REAL));
	Magnet mag=p->magfromparams(aa);
	array_1d_free(aa);
	for (n=0;n<m;n++)
	{
		x=V2_new(b0.x+(b1.x-b0.x)*n/(m-1),0.5*(b0.y+b1.y));
		e=Magnet_field(mag,x)-GoalFields_field(&p->goals,x);
		if (Magnet_errorset_field) e+=Magnet_errorset_field(x);
		//chebfac=asin(2.0*(n+1)/m-1.0)-asin(2.0*n/m-1.0);
		b[n*2]=e.x; b[n*2+1]=e.y;
	}
	Magnet_free(mag);
}
