#include <magnet/PM2D_saveps.c>
#include <magnet/PM2D_saveopera2d.c>
#include <magnet/PM2D_saveopera3d.c>
#include <magnet/rotatingcoil.c>
#ifdef HALBACHAREA_STANDALONE
#include "optimise.c"
#else
#include "../../optimise.c"
#endif

REAL minthick=0,maxthick=0.2;
#ifdef HALBACHAREA_STANDALONE
#include "makemagnet_modifiers.c"
#include "makemagnet_halbach_open.c"
#include "makemagnet_halbach_ovalwedges.c"
#else
#include "../../makemagnet_modifiers.c"
#include "../../makemagnet_halbach_open.c"
#include "../../makemagnet_halbach_ovalwedges.c"
#endif

REAL glob_max_area=0;
HalbachOpen glob_p=HalbachOpen_default;
REAL glob_yoval=0,glob_clearance=0;

Magnet makemagnet_param_anyarea(const REAL *a)
{
	Magnet ret;
	if (glob_yoval>0) ret=makemagnet_halbach_ovalwedges_auto(a,
		glob_yoval,glob_p.R-glob_yoval,glob_p.Br,glob_p.ymidplane,60 degrees,glob_p.thmidplane);
	else ret=makemagnet_halbach_open(a,glob_p);
	if (glob_clearance>0) Magnet_shrinkpieces(&ret,0.5*glob_clearance);
	return ret;
}

Magnet makemagnet_param(const REAL *a)
{
	Magnet ret=makemagnet_param_anyarea(a);
	if (glob_max_area<=0 || Magnet_area(ret)<=glob_max_area) return ret;
	Magnet_free(ret);
	REAL *b=array_1d(array_1d_m(a)),k,kmin=0,kmax=1,ar;
	for (int i=30;i>0;i--)
	{
		if (kmax==0) {if (kmin==0) k=1; else k=kmin*2;} else k=0.5*(kmin+kmax);
		array_1d_eq(b,a); array_1d_scale(b,k);
		ret=makemagnet_param_anyarea(b);
		ar=Magnet_area(ret);
		if (ar<glob_max_area) kmin=k; else kmax=k;
		if (i>1) Magnet_free(ret);
	}
	array_1d_free(b);
	return ret;
}

void params_reset(REAL *a)
{
	for (int n=array_1d_m(a)-1;n>=0;n--) a[n]=0.005*sin(100.0*cos(n));
}

#include <rnd/setextension.c>

REAL halbacharea_esuccess=1e-3,halbacharea_estop=1e-5;
int halbacharea_maxiters=25,halbacharea_maxpole=20;
int halbacharea_quiet=0;

REAL halbacharea_save_length=1.23456; // For OPERA-3D export

int halbacharea(const GoalField goal,const HalbachOpen p,
	const char *savefile=NULL,
	Magnet *pmag=NULL,REAL *pn=NULL,REAL *ps=NULL,
	const REAL yoval=0,const REAL clearance=0)
{ // Returns 1 on success, 0 on failure
	int n,i; char str[300],str2[200];
	int gm=array_1d_m(goal.norm);
	if (!halbacharea_quiet)
	{
		sprintf(str,"Designing Halbach magnet for R=%g gfr=%lg",p.R,goal.gfr);
		if (0<gm && goal.norm[0]!=0) {sprintf(str2," dipole=%lg",goal.norm[0]); strcat(str,str2);}
		if (1<gm && goal.norm[1]!=0) {sprintf(str2," quad=%lg",goal.norm[1]); strcat(str,str2);}
		if (2<gm && goal.norm[2]!=0) {sprintf(str2," sext=%lg",goal.norm[2]); strcat(str,str2);}
		if (3<gm && goal.norm[3]!=0) {sprintf(str2," oct=%lg",goal.norm[3]); strcat(str,str2);}
		for (n=4;n<gm;n++) if (goal.norm[n]!=0) {sprintf(str2," p%d=%lg",n*2+2,goal.norm[n]); strcat(str,str2);}
		for (n=0;n<gm;n++) if (goal.skew[n]!=0) {sprintf(str2," p%ds=%lg",n*2+2,goal.skew[n]); strcat(str,str2);}
		reporta(str);
	}
	glob_p=p; glob_yoval=yoval; glob_clearance=clearance;
	REAL Bref=0; 
	for (i=gm-1;i>=0;i--) Bref=Max(Bref,Max(fabs(goal.norm[i]),fabs(goal.skew[i]))*pow(p.R,i));
	REAL esuccess=halbacharea_esuccess*Bref,estop=halbacharea_estop*Bref;
	int am=makemagnet_halbach_open_params(p);
	REAL *a=array_1d(am);
	params_reset(a);
	int pm,output_poles=(pn!=NULL);
	if (output_poles) pm=array_1d_m(pn);
	else {pm=halbacharea_maxpole; pn=array_1d(pm); ps=array_1d(pm);}
	REAL emax,area;
	MagnetProblem mprob; /**/ // Maybe a separate function to get mprob.goals, could use for multi-coil multipole output later?
	if (yoval>0)
	{
		mprob.goals=GoalFields_horizontal(goal,yoval*0.4);
	}
	else
	{
		mprob.goals=LSet(GoalField);
		GoalField goalcopy=GoalField_copy(goal);
		LSet_add(&mprob.goals,&goalcopy);
	}
	mprob.magfromparams=makemagnet_param;
	FL2Problem prob=
		FL2Problem_new((FL2Problem_fn)Magnet_rotatingcoils_interleaved_FL2,array_1d_m(a),pm*2*mprob.goals.m,&mprob);
		//FL2Problem_new((FL2Problem_fn)Magnet_rotatingcoils_interleaved_area_FL2,array_1d_m(a),pm*2*mprob.goals.m+1,&mprob); // Small weighting to minimise area
	REAL lambda_svd=1,rp;
	Magnet mag;
	for (n=0;n<halbacharea_maxiters;n++)
	{
		REAL *olda=array_1d_copy(a);
		FL2Problem_svd(&prob,a,&lambda_svd,1,1); // Nonlinear version of this is actually too clever! (ugly magnet, marginally better field quality)
		array_1d_sub(olda,a);
		REAL adiff=array_1d_norm(olda);
		array_1d_free(olda);
		mag=makemagnet_param(a);
		GoalField *g=(GoalField *)mprob.goals.a;
		emax=0;
		for (i=mprob.goals.m-1;i>=0;i--)
		{
			Magnet_rotatingcoil(mag,g[i].gfc,g[i].gfr,pn,ps);
			rotatingcoil_subtract_GoalField(pn,ps,g[i]);
			for (i=pm-1;i>=0;i--) emax=Max(emax,Max(fabs(pn[i]),fabs(ps[i])));
		}
		area=Magnet_area(mag);
		Magnet_free(mag);
		if (!halbacharea_quiet)
		{
			sprintf(str,"Iteration %d, error=%lg T, area=%lg cm^2",1+n,emax,area/1e-4); report(str);
		}
		if (emax<=estop || adiff==0) break; // 1e-5 you go home early
	}
	mag=makemagnet_param(a);
	if (savefile)
	{
		Magnet_save(mag,savefile);
		char *psfile=setextension(savefile,"ps");
		Magnet_saveps(mag,psfile,&mprob.goals);
		sprintf(str,"ps2pdf %s",psfile); system(str); free(psfile);
/**/ // Could consider doing a Magnet_mergenearbypoints to avoid meshing errors when points are say <10um apart (a 1um gap gave problems)
		char *comifile=setextension(savefile,"comi");
		Magnet_saveopera2d(mag,comifile,0.05*p.R); free(comifile);
		char o3df[500]; sprintf(o3df,"%s_3d.comi",savefile);
		Magnet_saveopera3d(mag,o3df,halbacharea_save_length);
		char mpf[500]; sprintf(mpf,"%s_%%smidplane.csv",savefile);
		Magnet_GoalFields_savemidplane(mag,&mprob.goals,mpf);
	}
	if (output_poles) Magnet_rotatingcoil(mag,goal.gfc,goal.gfr,pn,ps);
	else {array_1d_free(pn); array_1d_free(ps);}
	MagnetProblem_free(&mprob); // Also frees GoalField(s) i.e. goalcopy here (but not goal)
	if (pmag) *pmag=mag; else Magnet_free(mag);
	return emax<=esuccess; // 1e-3 at gfr is passable
}
