#ifndef SBCLIB_MAGNET_SIPOLES
// Converts multipole arrays in T/m^n into fields; [0] is dipole, [1] is quad etc.
#ifndef REAL
#define REAL double
#endif
#include <v2.c>

V2 sipoles_field(const REAL *pn,const REAL *ps,const int m,const V2 p)
{ // Input multipole arrays converted to SI units, get field at p (m explicit since not always an array_1d input)
	V2 ret=V2_zero,vn=V2_new(0,1),vs=V2_new(1,0); REAL ox;
	for (int n=0;n<m;n++)
	{
		ret+=pn[n]*vn+ps[n]*vs;
		ox=vn.x; vn.x=p.x*ox+p.y*vn.y; vn.y=p.x*vn.y-p.y*ox;
		ox=vs.x; vs.x=p.x*ox+p.y*vs.y; vs.y=p.x*vs.y-p.y*ox;
	}
	return ret;
}

V2 sipoles_gradient(const REAL *pn,const REAL *ps,const int m,const V2 p)
{
	V2 ret=V2_zero,vn=V2_new(1,0),vs=V2_new(0,1); REAL ox;
	for (int n=1;n<m;n++)
	{
		ret+=n*(pn[n]*vn+ps[n]*vs);
		ox=vn.x; vn.x=p.x*ox+p.y*vn.y; vn.y=p.x*vn.y-p.y*ox;
		ox=vs.x; vs.x=p.x*ox+p.y*vs.y; vs.y=p.x*vs.y-p.y*ox;
	}
	return ret;
}

void sipoles_shift(const REAL *pn,const REAL *ps,const int m,const V2 x,
	REAL *xn,REAL *xs)
{ // Gives multipoles centered around x, so that B_out(p)=B_in(x+p)
	int n,i; REAL c,px; V2 p;
	for (n=0;n<m;n++) {xn[n]=0; xs[n]=0;}
	for (n=0;n<m;n++)
	{
		c=1; p=V2_new(1,0); // Feed-down of multipole n
		for (i=n;i>=0;i--)
		{
			xn[i]+=c*(pn[n]*p.x-ps[n]*p.y);
			xs[i]+=c*(ps[n]*p.x+pn[n]*p.y);
			c*=i; c/=n-i+1;
			px=p.x; p.x=x.x*px-x.y*p.y; p.y=x.x*p.y+x.y*px;
		}
	}
}
/*
#include <rnd/frnd.c>
void sipoles_shift_test(void)
{
	int n,i,m=4;
	REAL *pn=(REAL *)malloc(m*sizeof(REAL)),*ps=(REAL *)malloc(m*sizeof(REAL)),
		*xn=(REAL *)malloc(m*sizeof(REAL)),*xs=(REAL *)malloc(m*sizeof(REAL));
	V2 x,p,q,Bin,Bout;
	for (i=0;i<10;i++)
	{
		printf("Initial poles:");
		for (n=0;n<m;n++)
		{
			pn[n]=frnd(2)-1; ps[n]=frnd(2)-1;
			printf(" [%d]=(%lg,%lg)",n,pn[n],ps[n]);
		}
		x=V2_new(frnd(2)-1,frnd(2)-1);
		printf("\nShift x=(%lg,%lg)\nShifted poles:",x.x,x.y);
		sipoles_shift(pn,ps,m,x,xn,xs);
		for (n=0;n<m;n++)
		{
			printf(" [%d]=(%lg,%lg)",n,xn[n],xs[n]);
		}
		p=V2_new(frnd(2)-1,frnd(2)-1); q=x+p;
		printf("\nTest point p=(%lg,%lg), x+p=(%lg,%lg)\n",p.x,p.y,q.x,q.y);
		Bin=sipoles_field(pn,ps,m,q);
		Bout=sipoles_field(xn,xs,m,p);
		printf("B_out(p) = (%lg,%lg)\n",Bout.x,Bout.y);
		printf("B_in(x+p) = (%lg,%lg)\n",Bin.x,Bin.y);
		getchar();
	}
	free(pn); free(ps); free(xn); free(xs);
}
*/
#define SBCLIB_MAGNET_SIPOLES
#endif
