#ifndef SBCLIB_RND_eithertime
#if defined(__linux__) || defined(__APPLE__)
#include <time.h> // Must normally link LibRT with the -lrt switch
double eithertime(void)
{
	struct timespec t;
	clock_gettime(CLOCK_REALTIME,&t);
	return (double)t.tv_sec+1e-9*t.tv_nsec;
}
#else
#include <windows.h>
double LARGE_INTEGER_to_double(const LARGE_INTEGER x)
{
	return x.HighPart*4294967296.0+x.LowPart;
}

double eithertime1(void);
double (*eithertime)(void)=eithertime1,eithertime_QPC_dt;
double eithertime_QPC(void)
{
	LARGE_INTEGER t; QueryPerformanceCounter(&t);
	return eithertime_QPC_dt*(t.HighPart*4294967296.0+t.LowPart);
}
double eithertime_GTC(void) {return 0.001*GetTickCount();}
double eithertime1(void)
{
	LARGE_INTEGER f;
	if (QueryPerformanceFrequency(&f))
	{
		eithertime_QPC_dt=1.0/LARGE_INTEGER_to_double(f);
		eithertime=eithertime_QPC;
	}
	else eithertime=eithertime_GTC;
	return eithertime();
}
#endif
#define SBCLIB_RND_eithertime
#endif
