#ifndef SBCLIB_MAGNET_PM2D_SAVEOPERA3D
#include <magnet/PM2D.c>
#include <rnd/Maxi.c>

void PMPoly_writeopera3d(const PMPoly p,const int count,FILE *out,const REAL length=1.23456)
{
	int n,m=p.p.m; V2 *v=(V2 *)p.p.a;
	fprintf(out,"\n");
	for (n=0;n<m;n++)
	{
		int ni=(n+1)%m;
		if (n==0) fprintf(out,"WIREEDGE NAME=WireEdge%d X0=%.9lf Y0=%.9lf Z0=%.9lf X1=%.9lf Y1=%.9lf Z1=%.9lf EDGETYPE=STRAIGHT UNIQUENAME=WireEdge%d CONTINUE=Yes\n",
			count,v[n].x/1e-3,v[n].y/1e-3,0.l,v[ni].x/1e-3,v[ni].y/1e-3,0.l,count);
		else fprintf(out,"WIREEDGE X0=%.9lf Y0=%.9lf Z0=%.9lf  NAME=WireEdge%d X1=%.9lf Y1=%.9lf Z1=%.9lf EDGETYPE=STRAIGHT CONTINUE=%s\n",
			v[n].x/1e-3,v[n].y/1e-3,0.l,count,v[ni].x/1e-3,v[ni].y/1e-3,0.l,(ni?"Yes":"Close"));
	}
	for (n=0;n<m;n++)
	{
		fprintf(out,"PICK PTU=88 PTV=0 PTW=44 WAIT=NO WILDCARD=NO OPTION=TOGGLE TYPE=EDGE UNIQUEBODYNAME=WireEdge%d IDENTIFIER=%c.00001\n",
			count,'A'+n);
	}
	fprintf(out,"COVER NAME=Cover%d UNIQUENAME=Cover%d\n",count,count);
	fprintf(out,"PICK PTU=88 PTV=0 PTW=44 WAIT=NO WILDCARD=NO OPTION=TOGGLE TYPE=FACE UNIQUEBODYNAME=Cover%d IDENTIFIER=%c.00001\n",count,'A'+m);
	fprintf(out,"SWEEP TWISTTYPE=NONE KEEP=NO TYPE=DISTANCE REGULARIZE=NO RIGID=NO DISTANCE=%lg DRAFTTYPE=NONE\n",length/1e-3);

	fprintf(out,"PICK PTU=88 PTV=0 PTW=44 WAIT=NO WILDCARD=NO OPTION=ADD PROPERTY=UniqueName LABEL=Cover%d\n",count);
	fprintf(out,"CELLDATA OPTION=MODIFY MATERIALLABEL=PMmuEqualOne POTENTIAL=Default ELEMENTTYPE=Linear LEVEL=10 VOLUMELABEL=_directed%d SIZE=4 ELEMSHAPEPREF=NONE\n",count);
	fprintf(out,"VOLUME OPTION=PICK VOLUMELABEL=_directed%d\n",count);
	fprintf(out,"VOLUME OPTION=MODIFY THETA=90 PHI=%.9lf PSI=0\n",
		atan2(p.Br.y,p.Br.x) radians);
	fprintf(out,"VOLUME OPTION=UNPICK\n");

	fprintf(out,"INSERTOP2FILE IGNOREAIR=YES USEGROUP=NO GROUPLABEL=YES MATERIALLABEL=YES REGIONLABEL=NO SWEEPDISTANCE=1 OPTION=CLEAR\n");
	fprintf(out,"PICK PTU=88 PTV=0 PTW=44 WAIT=NO WILDCARD=NO OPTION=TOGGLE PROPERTY=UniqueName LABEL=Cover%d\n",count);
}

void Magnet_saveopera3d(const Magnet mag,const char *filename,const REAL length=1.23456)
{ // OPERA-3D .comi format
	int n; PMPoly *p=(PMPoly *)mag.pmpolys.a;
	FILE *out=fopen(filename,"wt");
	fprintf(out,"/ Opera-3d Modeller\n\
/ Opera 2021 SP3 [Build 3]\n\n");

	REAL Br=V2_norm(p[0].Br); // Only a single strength material supported for now
	fprintf(out,"BHData Option=Init Label=PM_BH_Curve  CGS=NO\n");
	for (REAL B=-4;B<=4.01;B++)
	{ // B=mu0*H+Br  =>  H=(B-Br)/mu0
		REAL H=(B-Br)/mu0; // mu=mu0 or mu_r=1 assumed, as in 2D current sheet model
		fprintf(out,"BHData Option=Add Label=PM_BH_Curve H=%.9lg B=%.9lg\n",H,B);
	}

	fprintf(out,"\n// Start modelling operations\n");

	fprintf(out,"MATERIALS OPTION=PICK MATERIALLABEL=PMmuEqualOne\n");
	fprintf(out,"MATERIALS MU=1.0 HC=0.0 MPHASE=0 MUXX=1.0 MUYY=1.0 MUZZ=1.0 HCX=0.0 HCY=0.0 HCZ=0.0 MAPHASE=0 SIGANISOTROPY=ISOTROPIC SIGMA=0.0 SPHASE=0 SIGXX=0.0 SIGYY=0.0 SIGZZ=0.0 SAPHASE=0 EPSANISOTROPY=ISOTROPIC EPSILON=1.0 EPHASE=0 EPSXX=1.0 EPSYY=1.0 EPSZZ=1.0 EAPHASE=0 KAPANISOTROPY=ISOTROPIC BASENAME=PMmuEqualOne IW=NEO_I JOULEHEAT=YES USESIBC=No MECHANICALANISOTROPY=Isotropic THERMALEXPANSION=0 GENERALEXPANSION=0 THERMALEXPANSIONX=0 THERMALEXPANSIONY=0 THERMALEXPANSIONZ=0 GENERALEXPANSIONX=0 GENERALEXPANSIONY=0 GENERALEXPANSIONZ=0 OPTION=MODIFY MULINEARITY=NONLINEAR MUANISOTROPY=ISOTROPIC BH=PM_BH_Curve\n");
	fprintf(out,"MATERIALS OPTION=UNPICK\n");

	for (n=0;n<mag.pmpolys.m;n++) PMPoly_writeopera3d(p[n],n,out,length);
	fclose(out);
}

#define SBCLIB_MAGNET_PM2D_SAVEOPERA3D
#endif
