#ifndef SBCLIB_RND_sjbdatetime
char sjbdatebuf[20],sjbtimebuf[20],sjbdatetimebuf[30];
#if defined(__linux__) || defined(__APPLE__)
#include <time.h>
char *sjbdatetime(void)
{
	time_t t=time(NULL);
	struct tm tm; gmtime_r(&t,&tm);
	strftime(sjbdatetimebuf,30,"%Y-%b-%d %H:%M:%S",&tm);
	return sjbdatetimebuf;
}
#else
#include <windows.h>
#include <math.h>
#include <rnd/MakeSystemTime.c>

const char sjbdatef[30]="yyyy-MMM-dd",sjbtimef[30]="HH:mm:ss",
	isodatef[30]="yyyy-MM-dd";
	
#define SJBDATETIME_NOW -9e99

char *sjbdatetime(const double unixtime=SJBDATETIME_NOW,char *buf=sjbdatetimebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	char str[100],str2[100]; SYSTEMTIME st,*pst=NULL;
	if (unixtime!=SJBDATETIME_NOW) MakeSystemTime(unixtime,pst=&st);
	GetDateFormat(LOCALE_USER_DEFAULT,0,pst,sjbdatef,str,100);
	GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,pst,sjbtimef,str2,100);
	sprintf(buf,"%s %s",str,str2);
	return buf;
}

char *isodatetime(const double unixtime=SJBDATETIME_NOW,char *buf=sjbdatetimebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	char str[100],str2[100]; SYSTEMTIME st,*pst=NULL;
	if (unixtime!=SJBDATETIME_NOW) MakeSystemTime(unixtime,pst=&st);
	GetDateFormat(LOCALE_USER_DEFAULT,0,pst,isodatef,str,100);
	GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,pst,sjbtimef,str2,100);
	sprintf(buf,"%s %s",str,str2);
	return buf;
}

char *sjbdatetime_fromfiletime(const FILETIME ft,char *buf=sjbdatetimebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	char str[100],str2[100]; SYSTEMTIME st,*pst;
	FileTimeToSystemTime(&ft,pst=&st);
	GetDateFormat(LOCALE_USER_DEFAULT,0,pst,sjbdatef,str,100);
	GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,pst,sjbtimef,str2,100);
	sprintf(buf,"%s %s",str,str2);
	return buf;
}

char *isodatetime_fromfiletime(const FILETIME ft,char *buf=sjbdatetimebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	char str[100],str2[100]; SYSTEMTIME st,*pst;
	FileTimeToSystemTime(&ft,pst=&st);
	GetDateFormat(LOCALE_USER_DEFAULT,0,pst,isodatef,str,100);
	GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,pst,sjbtimef,str2,100);
	sprintf(buf,"%s %s",str,str2);
	return buf;
}

char *sjbdate(const double unixtime=SJBDATETIME_NOW,char *buf=sjbdatebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	SYSTEMTIME st,*pst=NULL;
	if (unixtime!=SJBDATETIME_NOW) MakeSystemTime(unixtime,pst=&st);
	GetDateFormat(LOCALE_USER_DEFAULT,0,pst,sjbdatef,buf,20);
	return buf;
}

char *sjbtime(const double unixtime=SJBDATETIME_NOW,char *buf=sjbtimebuf)
{ // Returns the time _now_ if second argument not present (uses UTC for unixtime, no DST!)
	SYSTEMTIME st,*pst=NULL;
	if (unixtime!=SJBDATETIME_NOW) MakeSystemTime(unixtime,pst=&st);
	GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,pst,sjbtimef,buf,20);
	return buf;
}
#endif
#define SBCLIB_RND_sjbdatetime
#endif
