// Oval magnets also using wedges in the central section

Magnet makemagnet_halbach_ovalwedges(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const int mends,const REAL ymidplane=0,const REAL thends=60 degrees,const REAL thmidp=0 degrees)
{ // Straight part x in [-X,X], total aperture (x,y) in [-X-R,X+R]*[-R,R]; 
	Magnet ret=Magnet_new();
	if (array_1d_m(a)%2) reportfatal("Odd number of parameters given to makemagnet_halbach_ovalwedges");
	int wm=array_1d_m(a)/2,mtop=wm-mends*2;
	REAL thtop=M_PI-thends*2;
	if (mtop<0 || X>0 && mtop==0) {char str[200]; sprintf(str,"mends=%d so %d end wedges, but %d parameters implies only %d wedges total in makemagnet_halbach_ovalwedges (mtop=%d)",mends,mends*2,array_1d_m(a),wm,mtop); reportfatala(str);}
	REAL r=noneg(R-ymidplane)/(sin(thends)-sin(thmidp)),
		cx=X+sqrt(noneg(R*R-ymidplane*ymidplane))-r*cos(thmidp),cy=ymidplane-r*sin(thmidp),
		xtop=cx+r*cos(thends);
	int n; PMPoly p; REAL th1,th2,ro;
	for (n=0;n<mends;n++)
	{
		th1=thmidp+n*(thends-thmidp)/mends;
		th2=thmidp+(n+1)*(thends-thmidp)/mends;
		ro=r+Min(maxthick,sqrt(sq(a[n*2])+sq(a[n*2+1])));
		p=PMPoly_new();
		Poly_addpoint(&p.p,ro*-cos(th1)-cx,ro*sin(th1)+cy);
		Poly_addpoint(&p.p,ro*-cos(th2)-cx,ro*sin(th2)+cy);
		Poly_addpoint(&p.p,r*-cos(th2)-cx,r*sin(th2)+cy);
		Poly_addpoint(&p.p,r*-cos(th1)-cx,r*sin(th1)+cy);
		p.Br=Br*V2_normalise(V2_new(a[n*2],a[n*2+1]));
		LSet_add(&ret.pmpolys,&p);
	}
	REAL x1,x2,yo,x1o,x2o;
	for (;n<mends+mtop;n++)
	{
		x1=(n-mends)*xtop*2.0/mtop-xtop;
		x2=(n+1-mends)*xtop*2.0/mtop-xtop;
		th1=thends+(n-mends)*thtop/mtop;
		th2=thends+(n+1-mends)*thtop/mtop;
		yo=R+Min(maxthick,sqrt(sq(a[n*2])+sq(a[n*2+1])));
		x1o=x1+(yo-R)*tan(th1-0.5*M_PI);
		x2o=x2+(yo-R)*tan(th2-0.5*M_PI);
		p=PMPoly_new();
		Poly_addpoint(&p.p,x1o,yo);
		Poly_addpoint(&p.p,x2o,yo);
		Poly_addpoint(&p.p,x2,R);
		Poly_addpoint(&p.p,x1,R);
		p.Br=Br*V2_normalise(V2_new(a[n*2],a[n*2+1]));
		LSet_add(&ret.pmpolys,&p);
	}
	for (;n<wm;n++)
	{
		th1=M_PI-thends+(n-mends-mtop)*(thends-thmidp)/mends;
		th2=M_PI-thends+(n+1-mends-mtop)*(thends-thmidp)/mends;
		ro=r+Min(maxthick,sqrt(sq(a[n*2])+sq(a[n*2+1])));
		p=PMPoly_new();
		Poly_addpoint(&p.p,ro*-cos(th1)+cx,ro*sin(th1)+cy);
		Poly_addpoint(&p.p,ro*-cos(th2)+cx,ro*sin(th2)+cy);
		Poly_addpoint(&p.p,r*-cos(th2)+cx,r*sin(th2)+cy);
		Poly_addpoint(&p.p,r*-cos(th1)+cx,r*sin(th1)+cy);
		p.Br=Br*V2_normalise(V2_new(a[n*2],a[n*2+1]));
		LSet_add(&ret.pmpolys,&p);
	}
	Magnet_symm_xaxisyfield(&ret);
	return ret;
}

Magnet makemagnet_halbach_ovalwedges_auto(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const REAL ymidplane=0,const REAL thends=60 degrees,const REAL thmidp=0 degrees)
{ // Straight part x in [-X,X], total aperture (x,y) in [-X-R,X+R]*[-R,R];
	REAL qcirc=0.5*M_PI*R,qperim=qcirc+X,hperim=2.0*qperim;
	int wm=array_1d_m(a)/2,
		mends=Maxi(1,/*wm/3*/wm*qcirc/hperim),
		mtop=wm-mends*2;
	if (mtop<0 || X>0 && mtop==0)
	{
		char str[200]; sprintf(str,"wm=%d mends=%d mtop=%d in makemagnet_halbach_ovalwedges_auto",wm,mends,mtop);
		reportfatala(str);
	}
	return makemagnet_halbach_ovalwedges(a,R,X,Br,mends,ymidplane,thends,thmidp);
}

Magnet makemagnet_halbach_ovalwedges_dfm(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const int mends,const REAL ymidplane=0,const REAL thends=60 degrees,const REAL thmidp=0 degrees)
{ // am-piece (mends-mtop-mends)*2 design with only 2+mtop/2 distinct wedge shapes
	int n,i,am=array_1d_m(a);
	if (am%2) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm needs even number of parameters, got %d",am); reportfatala(str);}
	int wm=am/2,mtop=wm-mends*2;
	if (mtop<0) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm got %d parameters, so %d wedges, but mends=%d, which needs at least %d wedges",am,wm,mends,mends*2); reportfatala(str);}
	if (X>0 && mtop==0) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm got %d parameters, so %d wedges, but mends=%d, so mtop=%d but X=%lg>0, which needs at least one top wedge",am,wm,mends,mtop,X); reportfatala(str);}
	REAL *b=array_1d_copy(a),*l=array_1d(wm),lt;
	for (n=0;n<wm;n++) l[n]=sqrt(sq(b[n*2])+sq(b[n*2+1]));
	for (i=0;i<=wm-mends;i+=wm-mends)
	{
		lt=0;
		for (n=i;n<i+mends;n++) lt+=l[n];
		lt/=mends;
		for (n=i;n<i+mends;n++) {b[n*2]*=lt/l[n]; b[n*2+1]*=lt/l[n];}
	}
	for (i=mends;i<wm/2;i++)
	{
		lt=(l[i]+l[wm-1-i])/2.0;
		n=i; b[n*2]*=lt/l[n]; b[n*2+1]*=lt/l[n];
		n=wm-1-i; b[n*2]*=lt/l[n]; b[n*2+1]*=lt/l[n];
	}
	array_1d_free(l);
	Magnet ret=makemagnet_halbach_ovalwedges(b,R,X,Br,mends,ymidplane,thends,thmidp);
	array_1d_free(b);
	return ret;
}

Magnet makemagnet_halbach_ovalwedges_dfm24(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const REAL ymidplane=0,const REAL thends=60 degrees,const REAL thmidp=0 degrees)
{ // 24-piece (3-6-3)*2 design with only 5 distinct wedge shapes
	int am=array_1d_m(a);
	if (am!=24) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm24 needs 24 parameters, got %d",am); reportfatala(str);}
	return makemagnet_halbach_ovalwedges_dfm(a,R,X,Br,3,ymidplane,thends,thmidp);
}

Magnet makemagnet_halbach_ovalwedges_dfm_v(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const int mends,const REAL ymidplane=0,const REAL thmidp=0 degrees)
{ // Varies thends as an additional parameter
	int am=array_1d_m(a);
	if (am%2==0) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm_v needs odd number of parameters, got %d",am); reportfatala(str);}
	REAL *aa=array_1d(am-1); memcpy(aa,a+1,(am-1)*sizeof(REAL));
	Magnet ret=makemagnet_halbach_ovalwedges_dfm(aa,R,X,Br,mends,ymidplane,a[0],thmidp);
	array_1d_free(aa);
	return ret;
}

Magnet makemagnet_halbach_ovalwedges_dfm24_v(const REAL *a,const REAL R,const REAL X,const REAL Br,
	const REAL ymidplane=0,const REAL thmidp=0 degrees)
{ // Varies thends as an additional parameter
	int am=array_1d_m(a);
	if (am!=25) {char str[200]; sprintf(str,"makemagnet_halbach_ovalwedges_dfm24_v needs 25 parameters, got %d",am); reportfatala(str);}
	REAL *aa=array_1d(24); memcpy(aa,a+1,24*sizeof(REAL));
	Magnet ret=makemagnet_halbach_ovalwedges_dfm24(aa,R,X,Br,ymidplane,a[0],thmidp);
	array_1d_free(aa);
	return ret;
}

/**/ // Could add a parameter to displace entire magnet horizontally?
void Magnet_displace_ovalwedges(Magnet *pm,const REAL *a)
{ // th[0..m/2] are edge angles of magnets
	int n,m=pm->pmpolys.m;
	if (array_1d_m(a)!=m/2*2) {char str[200]; sprintf(str,"Magnet_displace_ovalwedges got %d parameters, expected %d",array_1d_m(a),m/2*2); reportfatala(str);}
	for (n=m-1;n>=m/2;n--)
	{
		PMPoly_free(((PMPoly *)pm->pmpolys.a)[n]);
		LSet_remove(&pm->pmpolys,n);
	}
 	PMPoly *p=(PMPoly *)pm->pmpolys.a; REAL th1,th2,dr1,dr2,drmax=0.01,k; V2 *va,v;
	for (n=m/2-1;n>=0;n--)
	{
		va=(V2 *)p[n].p.a;
		v=va[0]-va[3];
		th1=atan2(v.y,v.x); // Not the same angle convention as the other routine but it doesn't matter
		v=va[1]-va[2];
		th2=atan2(v.y,v.x);
		dr1=(a[n*2]>=0?1.0:-1.0)/sqrt(fabs(a[n*2]));
		//dr1=sq(a[n*2])/0.01; dr2=sq(a[n*2+1])/0.01;
		//k=(drmax*(dr1+dr2)/(drmax+dr1+dr2))/(dr1+dr2);
		//k=(tan((dr1+dr2)/drmax)*drmax)/(dr1+dr2);
		//dr1*=k; dr2*=k;
		Poly_move(&p[n].p,V2_polar(drmax*fabs(dr1),th1+(th2-th1)*sq(sin(1.0+a[n*2+1])) ));
		if (dr1<0) p[n].Br*=-1; // Allowed by swapping and flipping top/bottom wedge pair
	}
	Magnet_symm_xaxisyfield(pm);
}
