#ifndef SBCLIB_MAGNET_PM2D_SAVEOPERA2D
#include <magnet/PM2D.c>
#include <rnd/Maxi.c>

void PMPoly_writeopera2d(const PMPoly p,FILE *out,const REAL mesh)
{
	int n,m=p.p.m; V2 *v=(V2 *)p.p.a;
	fprintf(out,"/\n");
	fprintf(out,"DRAW SHAPE=POLYGON MATERIAL=8  N=0 PHASE=%.9lf\n",atan2(p.Br.y,p.Br.x) radians);
	for (n=0;n<m;n++)
	{
		fprintf(out,"CARTESIAN  XP=%.9lf YP=%.9lf",v[n].x/1e-3,v[n].y/1e-3);
		if (n>0) fprintf(out," N=%d",Maxi(1,floor(0.5+V2_dist(v[n],v[n-1])/mesh)));
		fprintf(out,"\n");
	}
	fprintf(out,"FINISH N=%d\n",Maxi(1,floor(0.5+V2_dist(v[0],v[m-1])/mesh)));
	fprintf(out,"QUITDRAW\n");
}

void Magnet_saveopera2d(const Magnet mag,const char *filename,const REAL mesh)
{ // OPERA-2D .comi format.  Typically put mesh=0.05*aperture radius
	FILE *out=fopen(filename,"wt");
	fprintf(out,"TEST DRAW=NO\n");
	int n; PMPoly *p=(PMPoly *)mag.pmpolys.a;
	for (n=0;n<mag.pmpolys.m;n++) PMPoly_writeopera2d(p[n],out,mesh);
	fclose(out);
}

#define SBCLIB_MAGNET_PM2D_SAVEOPERA2D
#endif
