#ifndef MUON1_CONSTANTS
// Physical constants
#include <math.h>

const double C=2.99792458e8; // Exact SI 1983
#define eV 1.602176634e-19 // Exact SI 2019
#define mu0 (4e-7*M_PI)
#define eps0 (1.0/(mu0*C*C))
#define inv4pieps0 (1e-7*C*C)
#define hPlanck 6.62607015e-34 // Exact SI 2019
#define hbar (hPlanck/M_TWOPI)
#define kBoltzmann 1.380649e-23 // Exact SI 2019
#define N_Avogadro 6.02214076e23 // Exact SI 2019
#define uDalton 1.66053906660e-27
#define Grav 6.67430e-11 //(15)

#define keV (1e3*eV)
#define MeV (1e6*eV) // OK, not fundamental but I use them so often
#define GeV (1e9*eV)
#define TeV (1e12*eV)

#define MUON1_CONSTANTS
#endif
