#ifndef SBCLIB_RND_macros
#include <stdio.h>
#include <math.h>

#define Bit(x,n) (((x)>>(n))&1)
#define degrees *M_PI/180
#define radians *180.0/M_PI

#ifndef max // Convenient but shouldn't be nested or have A and B with side-effects
#define max(A,B) ((A)>(B)?(A):(B))
#endif
#ifndef min
#define min(A,B) ((A)<(B)?(A):(B))
#endif

#if defined(__linux__) || defined(__APPLE__)
#define WINMAIN int main(int argc,char **argv) \
	{void SBCLIB_main2(int,char **,char *); \
	int n,len=0; for (n=argc-1;n>=0;n--) len+=strlen(argv[n])+1; char *s=(char *)malloc(len); \
	s[0]=0; for (n=0;n<argc;n++) {strcat(s,argv[n]); if (n+1<argc) strcat(s," ");} SBCLIB_main2(argc,argv,s); free(s); return 0;} \
	void SBCLIB_main2(int argc,char **argv,char *cmdline)
#define strcmpi strcasecmp

#elif COMMANDLINE // Console-mode
#define WINMAIN \
	void SBCLIB_main2(char *); \
	void main(int argc,char *argv[]) \
		{int n,len=0; for (n=argc-1;n>=0;n--) len+=strlen(argv[n])+1; char *s=(char *)malloc(len); \
		s[0]=0; for (n=0;n<argc;n++) {strcat(s,argv[n]); if (n+1<argc) strcat(s," ");} SBCLIB_main2(s); free(s);} \
	void SBCLIB_main2(char *cmdline)
#else // Windows
#define WINMAIN \
	void SBCLIB_main2(char *,HINSTANCE); \
	int WINAPI WinMain(HINSTANCE hinstance,HINSTANCE previous,LPSTR cmdline,int showcmd) \
		{SBCLIB_main2(GetCommandLine(),hinstance); return 0;} \
	void SBCLIB_main2(char *cmdline,HINSTANCE hinstance)
#endif

#define DEBUG(n) \
{ \
	FILE *outDB=fopen("tech\\log.txt","at"); \
	if (!outDB) outDB=fopen("tech\\log.txt","wt"); \
	fprintf(outDB,"%d ",n); \
	fflush(outDB); fclose(outDB); \
}

#define DEBUGSTR(s) \
{ \
	FILE *outDB=fopen("tech\\log.txt","at"); \
	if (!outDB) outDB=fopen("tech\\log.txt","wt"); \
	fprintf(outDB,"%s",s); \
	fflush(outDB); fclose(outDB); \
}

#define DEBUGSTART \
{ \
	FILE *outDB=fopen("tech\\log.txt","wt"); \
	fclose(outDB); \
}

#define ASSUME(xxx) if (!(xxx)) {char str[200]; MessageBox(winhandle,"Assumption xxx incorrect at line __LINE__","Assumption xxx incorrect at line __LINE__",MB_OK);}

#ifndef SBCLIB_DEBUG
#define mallocex(a,b) malloc(a)
#endif
#ifndef SBCLIB_DEBUG // Anti-cone boffers
#define isalloc(a) 1
#define DEBUG_screendump(a)
#define DEBUG_exon()
#define DEBUG_exoff()
#define DEBUG_prevpage()
#define DEBUG_nextpage()
#endif

#ifndef M_TWOPI
#define M_TWOPI (M_PI*2)
#endif
#ifndef M_SQRT3
#define M_SQRT3 1.7320508075688772935274463415059
#endif
#ifndef M_SQRT12
#define M_SQRT12 0.70710678118654752440084436210485
#endif

typedef int (*qsort_fn)(const void *,const void *);

#if defined(__linux__) || defined(__APPLE__)
#else // Windows
#define VK_ALT VK_MENU
#define VK_LALT VK_LMENU
#define VK_RALT VK_RMENU
#define VK_PLUS 0xBB // aka VK_OEM_PLUS http://msdn.microsoft.com/en-us/library/windows/desktop/dd375731(v=vs.85).aspx
#define VK_MINUS 0xBD // aka VK_OEM_MINUS

#ifndef __LCC__
#define VK_0 '0'
#define VK_1 '1'
#define VK_2 '2'
#define VK_3 '3'
#define VK_4 '4'
#define VK_5 '5'
#define VK_6 '6'
#define VK_7 '7'
#define VK_8 '8'
#define VK_9 '9'
#endif

/*// Code to generate definitions for "missing" VK_codes for GCC
#include <stdio.h>

void main(void)
{
	FILE *out=fopen("vkstuff.c","wt");
	for (char c='A';c<='Z';c++)
		fprintf(out,"#ifndef VK_%c\n#define VK_%c %d\n#endif\n",c,(int)c,c);
	fclose(out);
}
*/
#ifndef VK_A
#define VK_A 65
#endif
#ifndef VK_B
#define VK_B 66
#endif
#ifndef VK_C
#define VK_C 67
#endif
#ifndef VK_D
#define VK_D 68
#endif
#ifndef VK_E
#define VK_E 69
#endif
#ifndef VK_F
#define VK_F 70
#endif
#ifndef VK_G
#define VK_G 71
#endif
#ifndef VK_H
#define VK_H 72
#endif
#ifndef VK_I
#define VK_I 73
#endif
#ifndef VK_J
#define VK_J 74
#endif
#ifndef VK_K
#define VK_K 75
#endif
#ifndef VK_L
#define VK_L 76
#endif
#ifndef VK_M
#define VK_M 77
#endif
#ifndef VK_N
#define VK_N 78
#endif
#ifndef VK_O
#define VK_O 79
#endif
#ifndef VK_P
#define VK_P 80
#endif
#ifndef VK_Q
#define VK_Q 81
#endif
#ifndef VK_R
#define VK_R 82
#endif
#ifndef VK_S
#define VK_S 83
#endif
#ifndef VK_T
#define VK_T 84
#endif
#ifndef VK_U
#define VK_U 85
#endif
#ifndef VK_V
#define VK_V 86
#endif
#ifndef VK_W
#define VK_W 87
#endif
#ifndef VK_X
#define VK_X 88
#endif
#ifndef VK_Y
#define VK_Y 89
#endif
#ifndef VK_Z
#define VK_Z 90
#endif

#endif

#define SBCLIB_RND_macros
#endif

