#ifndef SBCLIB_RND_qsort_type

#define qsort_type_NSTACK 51 // NSTACK is the required auxiliary storage
#define qsort_type_SWAP(I,J) {temp=a[I]; a[I]=a[J]; a[J]=temp;}

#define QSORT(T) \
void qsort_##T(T *a,const int m) \
{ /* Adapted from Numerical Recipes in C */ \
	int ir=m-1; \
	if (ir<=0) return; \
	const int M=7; /* Here M is the size of subarrays sorted by straight insertion.  int not unsigned because compared with int difference! */ \
	int i,j,k,l=0,istack[qsort_type_NSTACK]; /* lvector(1,NSTACK); Yeah, LCC's "dynamic arrays" really don't work well - use macro size! */ \
	int jstack=0; \
	T x,temp; \
	while (1) \
	{ /* Insertion sort when subarray small enough. */ \
		if (ir-l<M) \
		{ \
			for (j=l+1;j<=ir;j++) \
			{ \
				x=a[j]; \
				for (i=j-1;i>=l;i--) \
				{ \
					if (a[i]<=x) break; \
					a[i+1]=a[i]; \
				} \
				a[i+1]=x; \
			} \
			if (jstack==0) break; \
			ir=istack[jstack--]; /* Pop stack and begin a new round of partitioning. */ \
			l=istack[jstack--]; \
		} \
		else \
		{ \
			k=(l+ir)>>1; /* Choose median of left, center, and right elements as partitioning element a. Also rearrange so that a[l] <= a[l+1] <= a[ir]. */ \
			qsort_type_SWAP(k,l+1); \
			if (a[l]>a[ir]) qsort_type_SWAP(l,ir); \
			if (a[l+1]>a[ir]) qsort_type_SWAP(l+1,ir); \
			if (a[l]>a[l+1]) qsort_type_SWAP(l,l+1); \
			i=l+1; /* Initialize pointers for partitioning. */ \
			j=ir; \
			x=a[l+1]; /* Partitioning element. */ \
			while (1) \
			{ /* Beginning of innermost loop. */ \
				do i++; while (a[i]<x); /* Scan up to find element > x. */ \
				do j--; while (a[j]>x); /* Scan down to find element < x. */ \
				if (j<i) break; /* Pointers crossed. Partitioning complete. */ \
				qsort_type_SWAP(i,j); /* Exchange elements. */ \
			} /* End of innermost loop. */ \
			a[l+1]=a[j]; /* Insert partitioning element. */ \
			a[j]=x; \
			jstack+=2; \
			/* Push pointers to larger subarray on stack, process smaller subarray immediately. */ \
			if (jstack>=qsort_type_NSTACK) return; /* nrerror("NSTACK too small in sort."); */ \
			if (ir-i+1>=j-l) \
			{ \
				istack[jstack]=ir; \
				istack[jstack-1]=i; \
				ir=j-1; \
			} \
			else \
			{ \
				istack[jstack]=j-1; \
				istack[jstack-1]=l; \
				l=i; \
			} \
		} \
	} \
}

#define SBCLIB_RND_qsort_type
#endif
